/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;

@Internal
public class XZInputStreamFactory
implements InflaterInputStreamFactory<XZCompressorInputStream> {
    private static final XZInputStreamFactory INSTANCE = new XZInputStreamFactory();

    public static XZInputStreamFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public XZCompressorInputStream create(InputStream in) throws IOException {
        return new XZCompressorInputStream(in, true);
    }

    @Override
    public Collection<String> getCommonFileExtensions() {
        return Collections.singleton("xz");
    }
}

