/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class IntMinimum
implements SimpleAccumulator<Integer> {
    private static final long serialVersionUID = 1L;
    private int min = Integer.MAX_VALUE;

    public IntMinimum() {
    }

    public IntMinimum(int value) {
        this.min = value;
    }

    @Override
    public void add(Integer value) {
        this.min = Math.min(this.min, value);
    }

    @Override
    public Integer getLocalValue() {
        return this.min;
    }

    @Override
    public void merge(Accumulator<Integer, Integer> other) {
        this.min = Math.min(this.min, other.getLocalValue());
    }

    @Override
    public void resetLocal() {
        this.min = Integer.MAX_VALUE;
    }

    public IntMinimum clone() {
        IntMinimum clone = new IntMinimum();
        clone.min = this.min;
        return clone;
    }

    @Override
    public void add(int value) {
        this.min = Math.min(this.min, value);
    }

    public int getLocalValuePrimitive() {
        return this.min;
    }

    public String toString() {
        return "IntMinimum " + this.min;
    }
}

