/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.flink.streaming.api.functions.async.ResultFuture;

public class DelegatingResultFuture<OUT>
implements BiConsumer<Collection<OUT>, Throwable> {
    private final ResultFuture<OUT> delegatedResultFuture;
    private final CompletableFuture<Collection<OUT>> completableFuture;

    public DelegatingResultFuture(ResultFuture<OUT> delegatedResultFuture) {
        this.delegatedResultFuture = delegatedResultFuture;
        this.completableFuture = new CompletableFuture();
        this.completableFuture.whenComplete((BiConsumer)this);
    }

    @Override
    public void accept(Collection<OUT> outs, Throwable throwable) {
        if (throwable != null) {
            this.delegatedResultFuture.completeExceptionally(throwable);
        } else {
            this.delegatedResultFuture.complete(outs);
        }
    }

    public CompletableFuture<Collection<OUT>> getCompletableFuture() {
        return this.completableFuture;
    }
}

