/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.DispatcherOperationCaches;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunner;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerService;
import org.apache.flink.runtime.rest.RestService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherResourceManagerComponent
implements AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherResourceManagerComponent.class);
    @Nonnull
    private final DispatcherRunner dispatcherRunner;
    @Nonnull
    private final ResourceManagerService resourceManagerService;
    @Nonnull
    private final LeaderRetrievalService dispatcherLeaderRetrievalService;
    @Nonnull
    private final LeaderRetrievalService resourceManagerRetrievalService;
    @Nonnull
    private final RestService webMonitorEndpoint;
    private final CompletableFuture<Void> terminationFuture;
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final FatalErrorHandler fatalErrorHandler;
    private final DispatcherOperationCaches dispatcherOperationCaches;

    DispatcherResourceManagerComponent(@Nonnull DispatcherRunner dispatcherRunner, @Nonnull ResourceManagerService resourceManagerService, @Nonnull LeaderRetrievalService dispatcherLeaderRetrievalService, @Nonnull LeaderRetrievalService resourceManagerRetrievalService, @Nonnull RestService webMonitorEndpoint, @Nonnull FatalErrorHandler fatalErrorHandler, @Nonnull DispatcherOperationCaches dispatcherOperationCaches) {
        this.dispatcherRunner = dispatcherRunner;
        this.resourceManagerService = resourceManagerService;
        this.dispatcherLeaderRetrievalService = dispatcherLeaderRetrievalService;
        this.resourceManagerRetrievalService = resourceManagerRetrievalService;
        this.webMonitorEndpoint = webMonitorEndpoint;
        this.fatalErrorHandler = fatalErrorHandler;
        this.terminationFuture = new CompletableFuture();
        this.shutDownFuture = new CompletableFuture();
        this.dispatcherOperationCaches = dispatcherOperationCaches;
        this.registerShutDownFuture();
        this.handleUnexpectedResourceManagerTermination();
    }

    private void handleUnexpectedResourceManagerTermination() {
        this.resourceManagerService.getTerminationFuture().whenComplete((ignored, throwable) -> {
            if (this.isRunning.get()) {
                this.fatalErrorHandler.onFatalError((Throwable)new FlinkException("Unexpected termination of ResourceManagerService.", (Throwable)throwable));
            }
        });
    }

    private void registerShutDownFuture() {
        FutureUtils.forward(this.dispatcherRunner.getShutDownFuture(), this.shutDownFuture);
    }

    public final CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    public CompletableFuture<Void> stopApplication(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        return this.internalShutdown(() -> this.resourceManagerService.deregisterApplication(applicationStatus, diagnostics));
    }

    public CompletableFuture<Void> stopProcess() {
        return this.internalShutdown(FutureUtils::completedVoidFuture);
    }

    private CompletableFuture<Void> internalShutdown(Supplier<CompletableFuture<?>> additionalShutdownAction) {
        if (this.isRunning.compareAndSet(true, false)) {
            CompletableFuture<Void> operationsConsumedFuture = this.dispatcherOperationCaches.shutdownCaches();
            CompletableFuture<Void> webMonitorShutdownFuture = FutureUtils.composeAfterwards(operationsConsumedFuture, this.webMonitorEndpoint::closeAsync);
            CompletableFuture<Void> closeWebMonitorAndAdditionalShutdownActionFuture = FutureUtils.composeAfterwards(webMonitorShutdownFuture, additionalShutdownAction);
            return FutureUtils.composeAfterwards(closeWebMonitorAndAdditionalShutdownActionFuture, this::closeAsyncInternal);
        }
        return this.terminationFuture;
    }

    private CompletableFuture<Void> closeAsyncInternal() {
        LOG.info("Closing components.");
        Exception exception = null;
        ArrayList terminationFutures = new ArrayList(3);
        try {
            this.dispatcherLeaderRetrievalService.stop();
        }
        catch (Exception e) {
            exception = ExceptionUtils.firstOrSuppressed(e, exception);
        }
        try {
            this.resourceManagerRetrievalService.stop();
        }
        catch (Exception e) {
            exception = ExceptionUtils.firstOrSuppressed(e, exception);
        }
        terminationFutures.add(this.dispatcherRunner.closeAsync());
        terminationFutures.add(this.resourceManagerService.closeAsync());
        if (exception != null) {
            terminationFutures.add(FutureUtils.completedExceptionally(exception));
        }
        FutureUtils.ConjunctFuture<Void> componentTerminationFuture = FutureUtils.completeAll(terminationFutures);
        componentTerminationFuture.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.terminationFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.terminationFuture.complete((Void)aVoid);
            }
        });
        return this.terminationFuture;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.stopApplication(ApplicationStatus.CANCELED, "DispatcherResourceManagerComponent has been closed.");
    }

    public int getRestPort() {
        return this.webMonitorEndpoint.getRestPort();
    }
}

