/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.operation.AbstractFileStoreScan;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.SchemaEvolutionUtil;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.types.logical.RowType;

public class AppendOnlyFileStoreScan
extends AbstractFileStoreScan {
    private final ConcurrentMap<Long, FieldStatsArraySerializer> schemaRowStatsConverters = new ConcurrentHashMap<Long, FieldStatsArraySerializer>();
    private final RowType rowType;
    private Predicate filter;

    public AppendOnlyFileStoreScan(RowType partitionType, RowType bucketKeyType, RowType rowType, SnapshotManager snapshotManager, SchemaManager schemaManager, long schemaId, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets) {
        super(partitionType, bucketKeyType, snapshotManager, schemaManager, schemaId, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets);
        this.rowType = rowType;
    }

    public AppendOnlyFileStoreScan withFilter(Predicate predicate) {
        this.filter = predicate;
        List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.rowType.getFieldNames(), this.bucketKeyType.getFieldNames());
        if (bucketFilters.size() > 0) {
            this.withBucketKeyFilter(PredicateBuilder.and(bucketFilters));
        }
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.filter == null || this.filter.test(entry.file().rowCount(), entry.file().valueStats().fields(this.getFieldStatsArraySerializer(entry.file().schemaId()), entry.file().rowCount()));
    }

    private FieldStatsArraySerializer getFieldStatsArraySerializer(long schemaId) {
        return this.schemaRowStatsConverters.computeIfAbsent(schemaId, id -> {
            TableSchema tableSchema = this.scanTableSchema();
            TableSchema schema = this.scanTableSchema((long)id);
            return new FieldStatsArraySerializer(schema.logicalRowType(), tableSchema.id() == id.longValue() ? null : SchemaEvolutionUtil.createIndexMapping(tableSchema.fields(), schema.fields()));
        });
    }
}

