/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.util.Preconditions;

public class NullAwareJoinHelper {
    public static int[] getNullFilterKeys(boolean[] filterNulls) {
        Preconditions.checkNotNull(filterNulls);
        ArrayList<Integer> nullFilterKeyList = new ArrayList<Integer>();
        for (int i = 0; i < filterNulls.length; ++i) {
            if (!filterNulls[i]) continue;
            nullFilterKeyList.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])nullFilterKeyList.toArray(new Integer[0]));
    }

    public static boolean shouldFilter(boolean nullSafe, boolean filterAllNulls, int[] nullFilterKeys, BinaryRowData key) {
        return !nullSafe && (filterAllNulls ? key.anyNull() : key.anyNull(nullFilterKeys));
    }
}

