/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.store.hive.objectinspector.TableStoreObjectInspectorFactory;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class TableStoreMapObjectInspector
implements MapObjectInspector {
    private final ObjectInspector keyObjectInspector;
    private final ObjectInspector valueObjectInspector;
    private final ArrayData.ElementGetter keyGetter;
    private final ArrayData.ElementGetter valueGetter;

    public TableStoreMapObjectInspector(LogicalType keyType, LogicalType valueType) {
        this.keyObjectInspector = TableStoreObjectInspectorFactory.create(keyType);
        this.valueObjectInspector = TableStoreObjectInspectorFactory.create(valueType);
        this.keyGetter = ArrayData.createElementGetter(keyType);
        this.valueGetter = ArrayData.createElementGetter(valueType);
    }

    public ObjectInspector getMapKeyObjectInspector() {
        return this.keyObjectInspector;
    }

    public ObjectInspector getMapValueObjectInspector() {
        return this.valueObjectInspector;
    }

    public Object getMapValueElement(Object o, Object key) {
        if (o == null || key == null) {
            return null;
        }
        MapData mapData = (MapData)o;
        ArrayData keyArrayData = mapData.keyArray();
        ArrayData valueArrayData = mapData.valueArray();
        for (int i = 0; i < mapData.size(); ++i) {
            Object k = this.keyGetter.getElementOrNull(keyArrayData, i);
            if (!Objects.equals(k, key)) continue;
            return this.valueGetter.getElementOrNull(valueArrayData, i);
        }
        return null;
    }

    public Map<?, ?> getMap(Object o) {
        if (o == null) {
            return null;
        }
        MapData mapData = (MapData)o;
        ArrayData keyArrayData = mapData.keyArray();
        ArrayData valueArrayData = mapData.valueArray();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < mapData.size(); ++i) {
            Object k = this.keyGetter.getElementOrNull(keyArrayData, i);
            Object v = this.valueGetter.getElementOrNull(valueArrayData, i);
            result.put(k, v);
        }
        return result;
    }

    public int getMapSize(Object o) {
        if (o == null) {
            return -1;
        }
        return ((MapData)o).size();
    }

    public String getTypeName() {
        return "map<" + this.keyObjectInspector.getTypeName() + "," + this.valueObjectInspector.getTypeName() + ">";
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.MAP;
    }
}

