/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.table.store.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.table.store.shaded.com.google.common.base.Joiner;
import org.apache.flink.table.store.shaded.org.apache.hive.common.util.HiveStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnProjectionUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ColumnProjectionUtils.class);
    public static final String READ_COLUMN_IDS_CONF_STR = "hive.io.file.readcolumn.ids";
    public static final String READ_NESTED_COLUMN_PATH_CONF_STR = "hive.io.file.readNestedColumn.paths";
    public static final String READ_ALL_COLUMNS = "hive.io.file.read.all.columns";
    public static final String READ_COLUMN_NAMES_CONF_STR = "hive.io.file.readcolumn.names";
    private static final String READ_COLUMN_IDS_CONF_STR_DEFAULT = "";
    private static final String READ_NESTED_COLUMN_PATH_CONF_STR_DEFAULT = "";
    private static final boolean READ_ALL_COLUMNS_DEFAULT = true;
    private static final Joiner CSV_JOINER = Joiner.on(",").skipNulls();

    @Deprecated
    public static void setFullyReadColumns(Configuration conf) {
        ColumnProjectionUtils.setReadAllColumns(conf);
    }

    @Deprecated
    @VisibleForTesting
    public static void setReadColumnIDs(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.setReadColumnIDConf(conf, "");
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    @Deprecated
    public static void appendReadColumnIDs(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    public static void setReadAllColumns(Configuration conf) {
        conf.setBoolean(READ_ALL_COLUMNS, true);
        ColumnProjectionUtils.setReadColumnIDConf(conf, "");
    }

    public static boolean isReadAllColumns(Configuration conf) {
        return conf.getBoolean(READ_ALL_COLUMNS, true);
    }

    public static void setReadColumns(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.setReadColumnIDConf(conf, "");
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids) {
        String id = ColumnProjectionUtils.toReadColumnIDString(ids);
        String old = conf.get(READ_COLUMN_IDS_CONF_STR, null);
        String newConfStr = HiveStringUtils.joinIgnoringEmpty(new String[]{id, old}, ',');
        ColumnProjectionUtils.setReadColumnIDConf(conf, newConfStr);
        conf.setBoolean(READ_ALL_COLUMNS, false);
    }

    public static void appendNestedColumnPaths(Configuration conf, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        String pathsStr = StringUtils.join((CharSequence)",", (String[])paths.toArray(new String[paths.size()]));
        String old = conf.get(READ_NESTED_COLUMN_PATH_CONF_STR, null);
        String newConfStr = pathsStr;
        if (old != null && !old.isEmpty()) {
            newConfStr = newConfStr + "," + old;
        }
        ColumnProjectionUtils.setReadNestedColumnPathConf(conf, newConfStr);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids, List<String> names, List<String> groupPaths) {
        if (ids.size() != names.size()) {
            LOG.warn("Read column counts do not match: " + ids.size() + " ids, " + names.size() + " names");
        }
        ColumnProjectionUtils.appendReadColumns(conf, ids);
        ColumnProjectionUtils.appendReadColumnNames(conf, names);
        ColumnProjectionUtils.appendNestedColumnPaths(conf, groupPaths);
    }

    public static void appendReadColumns(StringBuilder readColumnsBuffer, StringBuilder readColumnNamesBuffer, List<Integer> ids, List<String> names) {
        CSV_JOINER.appendTo(readColumnsBuffer, (Iterable<?>)ids);
        CSV_JOINER.appendTo(readColumnNamesBuffer, (Iterable<?>)names);
    }

    public static List<Integer> getReadColumnIDs(Configuration conf) {
        String skips = conf.get(READ_COLUMN_IDS_CONF_STR, "");
        String[] list = StringUtils.split((String)skips);
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (String element : list) {
            Integer toAdd = Integer.parseInt(element);
            if (result.contains(toAdd)) continue;
            result.add(toAdd);
        }
        return result;
    }

    public static Set<String> getNestedColumnPaths(Configuration conf) {
        String skips = conf.get(READ_NESTED_COLUMN_PATH_CONF_STR, "");
        return new HashSet<String>(Arrays.asList(StringUtils.split((String)skips)));
    }

    public static String[] getReadColumnNames(Configuration conf) {
        String colNames = conf.get(READ_COLUMN_NAMES_CONF_STR, "");
        if (colNames != null && !colNames.isEmpty()) {
            return colNames.split(",");
        }
        return new String[0];
    }

    private static void setReadColumnIDConf(Configuration conf, String id) {
        if (id.trim().isEmpty()) {
            conf.set(READ_COLUMN_IDS_CONF_STR, "");
        } else {
            conf.set(READ_COLUMN_IDS_CONF_STR, id);
        }
    }

    private static void setReadNestedColumnPathConf(Configuration conf, String nestedColumnPaths) {
        if ((nestedColumnPaths = nestedColumnPaths.toLowerCase()).trim().isEmpty()) {
            conf.set(READ_NESTED_COLUMN_PATH_CONF_STR, "");
        } else {
            conf.set(READ_NESTED_COLUMN_PATH_CONF_STR, nestedColumnPaths);
        }
    }

    private static void appendReadColumnNames(Configuration conf, List<String> cols) {
        String old = conf.get(READ_COLUMN_NAMES_CONF_STR, "");
        StringBuilder result = new StringBuilder(old);
        boolean first = old.isEmpty();
        for (String col : cols) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(col);
        }
        conf.set(READ_COLUMN_NAMES_CONF_STR, result.toString());
    }

    private static String toReadColumnIDString(List<Integer> ids) {
        String id = "";
        for (int i = 0; i < ids.size(); ++i) {
            id = i == 0 ? id + ids.get(i) : id + "," + ids.get(i);
        }
        return id;
    }

    private ColumnProjectionUtils() {
    }
}

