/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder.ConstraintBuilder;
import org.apache.hadoop.conf.Configuration;

public class SQLForeignKeyBuilder
extends ConstraintBuilder<SQLForeignKeyBuilder> {
    private String pkDb = "default";
    private String pkTable;
    private String pkName;
    private List<String> pkColumns = new ArrayList<String>();
    private int updateRule = 0;
    private int deleteRule = 0;

    public SQLForeignKeyBuilder() {
        super.setChild(this);
    }

    public SQLForeignKeyBuilder setPkDb(String pkDb) {
        this.pkDb = pkDb;
        return this;
    }

    public SQLForeignKeyBuilder setPkTable(String pkTable) {
        this.pkTable = pkTable;
        return this;
    }

    public SQLForeignKeyBuilder addPkColumn(String pkColumn) {
        this.pkColumns.add(pkColumn);
        return this;
    }

    public SQLForeignKeyBuilder setPkName(String pkName) {
        this.pkName = pkName;
        return this;
    }

    public SQLForeignKeyBuilder fromPrimaryKey(List<SQLPrimaryKey> pk) {
        this.pkDb = pk.get(0).getTable_db();
        this.pkTable = pk.get(0).getTable_name();
        for (SQLPrimaryKey pkcol : pk) {
            this.pkColumns.add(pkcol.getColumn_name());
        }
        this.pkName = pk.get(0).getPk_name();
        return this;
    }

    public SQLForeignKeyBuilder setUpdateRule(int updateRule) {
        this.updateRule = updateRule;
        return this;
    }

    public SQLForeignKeyBuilder setDeleteRule(int deleteRule) {
        this.deleteRule = deleteRule;
        return this;
    }

    public List<SQLForeignKey> build(Configuration conf) throws MetaException {
        this.checkBuildable("to_" + this.pkTable + "_foreign_key", conf);
        if (this.pkTable == null || this.pkColumns.isEmpty() || this.pkName == null) {
            throw new MetaException("You must provide the primary key table, columns, and name");
        }
        if (this.columns.size() != this.pkColumns.size()) {
            throw new MetaException("The number of foreign columns must match the number of primary key columns");
        }
        ArrayList<SQLForeignKey> fk = new ArrayList<SQLForeignKey>(this.columns.size());
        for (int i = 0; i < this.columns.size(); ++i) {
            SQLForeignKey keyCol = new SQLForeignKey(this.pkDb, this.pkTable, this.pkColumns.get(i), this.dbName, this.tableName, (String)this.columns.get(i), this.getNextSeq(), this.updateRule, this.deleteRule, this.constraintName, this.pkName, this.enable, this.validate, this.rely);
            keyCol.setCatName(this.catName);
            fk.add(keyCol);
        }
        return fk;
    }
}

