/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.hbase;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.hbase.Counter;

class ObjectCache<K, V> {
    private Map<K, V> cache;
    private final int maxSize;
    private Counter hits;
    private Counter misses;
    private Counter overflows;

    ObjectCache(int max, Counter hits, Counter misses, Counter overflows) {
        this.maxSize = max;
        this.cache = new HashMap();
        this.hits = hits;
        this.misses = misses;
        this.overflows = overflows;
    }

    void put(K key, V value) {
        if (this.cache.size() < this.maxSize) {
            this.cache.put(key, value);
        } else {
            this.overflows.incr();
        }
    }

    V get(K key) {
        V val = this.cache.get(key);
        if (val == null) {
            this.misses.incr();
        } else {
            this.hits.incr();
        }
        return val;
    }

    void remove(K key) {
        this.cache.remove(key);
    }

    void flush() {
        this.cache.clear();
    }
}

