/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.com.google.common.hash;

import java.io.Serializable;
import java.util.zip.Checksum;
import org.apache.flink.table.store.shaded.com.google.common.base.Preconditions;
import org.apache.flink.table.store.shaded.com.google.common.base.Supplier;
import org.apache.flink.table.store.shaded.com.google.common.hash.AbstractByteHasher;
import org.apache.flink.table.store.shaded.com.google.common.hash.AbstractStreamingHashFunction;
import org.apache.flink.table.store.shaded.com.google.common.hash.HashCode;
import org.apache.flink.table.store.shaded.com.google.common.hash.HashCodes;
import org.apache.flink.table.store.shaded.com.google.common.hash.Hasher;

final class ChecksumHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final Supplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(Supplier<? extends Checksum> checksumSupplier, int bits, String toString) {
        this.checksumSupplier = Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument(bits == 32 || bits == 64, "bits (%s) must be either 32 or 64", bits);
        this.bits = bits;
        this.toString = Preconditions.checkNotNull(toString);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher(this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte b) {
            this.checksum.update(b);
        }

        @Override
        protected void update(byte[] bytes, int off, int len) {
            this.checksum.update(bytes, off, len);
        }

        @Override
        public HashCode hash() {
            long value = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCodes.fromInt((int)value);
            }
            return HashCodes.fromLong(value);
        }
    }
}

