/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.streaming.connectors.kafka.table;

import java.io.Serializable;
import java.util.Objects;

public class SinkBufferFlushMode
implements Serializable {
    private static final int DISABLED_BATCH_SIZE = 0;
    private static final long DISABLED_BATCH_INTERVAL = 0L;
    public static final SinkBufferFlushMode DISABLED = new SinkBufferFlushMode(0, 0L);
    private final int batchSize;
    private final long batchIntervalMs;

    public SinkBufferFlushMode(int batchSize, long batchIntervalMs) {
        this.batchSize = batchSize;
        this.batchIntervalMs = batchIntervalMs;
        if (this.isEnabled() && (batchSize <= 0 || batchIntervalMs <= 0L)) {
            throw new IllegalArgumentException(String.format("batchSize and batchInterval must greater than zero if buffer flush is enabled, but got batchSize=%s and batchIntervalMs=%s", batchSize, batchIntervalMs));
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public boolean isEnabled() {
        return this.batchSize != 0 || this.batchIntervalMs != 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SinkBufferFlushMode that = (SinkBufferFlushMode)o;
        return this.batchSize == that.batchSize && this.batchIntervalMs == that.batchIntervalMs;
    }

    public int hashCode() {
        return Objects.hash(this.batchSize, this.batchIntervalMs);
    }
}

