/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;

public class BlockMetaData {
    private List<ColumnChunkMetaData> columns = new ArrayList<ColumnChunkMetaData>();
    private long rowCount;
    private long totalByteSize;
    private String path;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getTotalByteSize() {
        return this.totalByteSize;
    }

    public void setTotalByteSize(long totalByteSize) {
        this.totalByteSize = totalByteSize;
    }

    public void addColumn(ColumnChunkMetaData column) {
        this.columns.add(column);
    }

    public List<ColumnChunkMetaData> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public long getStartingPos() {
        return this.getColumns().get(0).getStartingPos();
    }

    public String toString() {
        return "BlockMetaData{" + this.rowCount + ", " + this.totalByteSize + " " + this.columns + "}";
    }

    public long getCompressedSize() {
        long totalSize = 0L;
        for (ColumnChunkMetaData col : this.getColumns()) {
            totalSize += col.getTotalSize();
        }
        return totalSize;
    }
}

