/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.store.file.schema.ArrayDataType;
import org.apache.flink.table.store.file.schema.AtomicDataType;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.DataType;
import org.apache.flink.table.store.file.schema.MapDataType;
import org.apache.flink.table.store.file.schema.MultisetDataType;
import org.apache.flink.table.store.file.schema.RowDataType;
import org.apache.flink.table.store.file.utils.JsonSerializer;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;

public class DataFieldSerializer
implements JsonSerializer<DataField> {
    public static final DataFieldSerializer INSTANCE = new DataFieldSerializer();

    @Override
    public void serialize(DataField dataField, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("id", dataField.id());
        generator.writeStringField("name", dataField.name());
        generator.writeFieldName("type");
        DataFieldSerializer.typeToJson(dataField.type(), generator);
        if (dataField.description() != null) {
            generator.writeStringField("description", dataField.description());
        }
        generator.writeEndObject();
    }

    @Override
    public DataField deserialize(JsonNode node) {
        int id = node.get("id").asInt();
        String name = node.get("name").asText();
        DataType type = DataFieldSerializer.typeFromJson(node.get("type"));
        JsonNode descriptionNode = node.get("description");
        String description = null;
        if (descriptionNode != null) {
            description = descriptionNode.asText();
        }
        return new DataField(id, name, type, description);
    }

    private static void typeToJson(DataType type, JsonGenerator generator) throws IOException {
        if (type instanceof AtomicDataType) {
            generator.writeString(type.logicalType.asSerializableString());
        } else if (type instanceof ArrayDataType) {
            generator.writeStartObject();
            generator.writeStringField("type", type.logicalType.isNullable() ? "ARRAY" : "ARRAY NOT NULL");
            generator.writeFieldName("element");
            DataFieldSerializer.typeToJson(((ArrayDataType)type).elementType(), generator);
            generator.writeEndObject();
        } else if (type instanceof MultisetDataType) {
            generator.writeStartObject();
            generator.writeStringField("type", type.logicalType.isNullable() ? "MULTISET" : "MULTISET NOT NULL");
            generator.writeFieldName("element");
            DataFieldSerializer.typeToJson(((MultisetDataType)type).elementType(), generator);
            generator.writeEndObject();
        } else if (type instanceof MapDataType) {
            generator.writeStartObject();
            generator.writeStringField("type", type.logicalType.isNullable() ? "MAP" : "MAP NOT NULL");
            generator.writeFieldName("key");
            DataFieldSerializer.typeToJson(((MapDataType)type).keyType(), generator);
            generator.writeFieldName("value");
            DataFieldSerializer.typeToJson(((MapDataType)type).valueType(), generator);
            generator.writeEndObject();
        } else if (type instanceof RowDataType) {
            generator.writeStartObject();
            generator.writeStringField("type", type.logicalType.isNullable() ? "ROW" : "ROW NOT NULL");
            generator.writeArrayFieldStart("fields");
            for (DataField field : ((RowDataType)type).fields()) {
                INSTANCE.serialize(field, generator);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        } else {
            throw new UnsupportedOperationException("Unsupported type: " + type);
        }
    }

    private static DataType typeFromJson(JsonNode json) {
        if (json.isTextual()) {
            return new AtomicDataType(LogicalTypeParser.parse(json.asText()));
        }
        if (json.isObject()) {
            String typeString = json.get("type").asText();
            if (typeString.startsWith("ARRAY")) {
                DataType element = DataFieldSerializer.typeFromJson(json.get("element"));
                return new ArrayDataType(!typeString.contains("NOT NULL"), element);
            }
            if (typeString.startsWith("MULTISET")) {
                DataType element = DataFieldSerializer.typeFromJson(json.get("element"));
                return new MultisetDataType(!typeString.contains("NOT NULL"), element);
            }
            if (typeString.startsWith("MAP")) {
                DataType key = DataFieldSerializer.typeFromJson(json.get("key"));
                DataType value = DataFieldSerializer.typeFromJson(json.get("value"));
                return new MapDataType(!typeString.contains("NOT NULL"), key, value);
            }
            if (typeString.startsWith("ROW")) {
                JsonNode fieldArray = json.get("fields");
                Iterator<JsonNode> iterator = fieldArray.elements();
                ArrayList<DataField> fields = new ArrayList<DataField>(fieldArray.size());
                while (iterator.hasNext()) {
                    fields.add(INSTANCE.deserialize(iterator.next()));
                }
                return new RowDataType(!typeString.contains("NOT NULL"), fields);
            }
        }
        throw new IllegalArgumentException("Can not parse: " + json);
    }
}

