/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.OptionalConsumer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class LeaderRetrievalHandler<T extends RestfulGateway>
extends SimpleChannelInboundHandler<RoutedRequest> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final GatewayRetriever<? extends T> leaderRetriever;
    protected final Time timeout;
    protected final Map<String, String> responseHeaders;

    protected LeaderRetrievalHandler(@Nonnull GatewayRetriever<? extends T> leaderRetriever, @Nonnull Time timeout, @Nonnull Map<String, String> responseHeaders) {
        this.leaderRetriever = Preconditions.checkNotNull(leaderRetriever);
        this.timeout = Preconditions.checkNotNull(timeout);
        this.responseHeaders = Preconditions.checkNotNull(responseHeaders);
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, RoutedRequest routedRequest) {
        HttpRequest request = routedRequest.getRequest();
        OptionalConsumer<RestfulGateway> optLeaderConsumer = OptionalConsumer.of(this.leaderRetriever.getNow());
        optLeaderConsumer.ifPresent(gateway -> {
            try {
                this.respondAsLeader(channelHandlerContext, routedRequest, gateway);
            }
            catch (Exception e) {
                this.logger.error("Error while responding to the http request.", (Throwable)e);
                HandlerUtils.sendErrorResponse(channelHandlerContext, request, new ErrorResponseBody("Error while responding to the http request."), HttpResponseStatus.INTERNAL_SERVER_ERROR, this.responseHeaders);
            }
        }).ifNotPresent(() -> HandlerUtils.sendErrorResponse(channelHandlerContext, request, new ErrorResponseBody("Service temporarily unavailable due to an ongoing leader election. Please refresh."), HttpResponseStatus.SERVICE_UNAVAILABLE, this.responseHeaders));
    }

    protected abstract void respondAsLeader(ChannelHandlerContext var1, RoutedRequest var2, T var3) throws Exception;
}

