/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyInstantTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyLocalDateTimeTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyTimestampTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.TimestampDataTypeInfo;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;

public class DataFormatConverters {
    private static final Map<DataType, DataFormatConverter> TYPE_TO_CONVERTER;

    public static DataFormatConverter getConverterForDataType(DataType originDataType) {
        DataType dataType = (DataType)originDataType.nullable();
        DataFormatConverter converter = TYPE_TO_CONVERTER.get(dataType);
        if (converter != null) {
            return converter;
        }
        Class<Tuple> clazz = dataType.getConversionClass();
        LogicalType logicalType = dataType.getLogicalType();
        switch (logicalType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                if (clazz == String.class) {
                    return StringConverter.INSTANCE;
                }
                if (clazz == StringData.class) {
                    return StringDataConverter.INSTANCE;
                }
                throw new RuntimeException("Not support class for VARCHAR: " + clazz);
            }
            case BINARY: 
            case VARBINARY: {
                return PrimitiveByteArrayConverter.INSTANCE;
            }
            case DECIMAL: {
                Tuple2<Integer, Integer> ps = DataFormatConverters.getPrecision(logicalType);
                if (clazz == BigDecimal.class) {
                    return new BigDecimalConverter((Integer)ps.f0, (Integer)ps.f1);
                }
                if (clazz == DecimalData.class) {
                    return new DecimalDataConverter((Integer)ps.f0, (Integer)ps.f1);
                }
                throw new RuntimeException("Not support conversion class for DECIMAL: " + clazz);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int precisionOfTS = DataFormatConverters.getDateTimePrecision(logicalType);
                if (clazz == Timestamp.class) {
                    return new TimestampConverter(precisionOfTS);
                }
                if (clazz == LocalDateTime.class) {
                    return new LocalDateTimeConverter(precisionOfTS);
                }
                if (clazz == TimestampData.class) {
                    return new TimestampDataConverter(precisionOfTS);
                }
                throw new RuntimeException("Not support conversion class for TIMESTAMP WITHOUT TIME ZONE: " + clazz);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int precisionOfLZTS = DataFormatConverters.getDateTimePrecision(logicalType);
                if (clazz == Instant.class) {
                    return new InstantConverter(precisionOfLZTS);
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return new LongTimestampDataConverter(precisionOfLZTS);
                }
                if (clazz == TimestampData.class) {
                    return new TimestampDataConverter(precisionOfLZTS);
                }
                if (clazz == Timestamp.class) {
                    return new TimestampLtzConverter(precisionOfLZTS);
                }
                throw new RuntimeException("Not support conversion class for TIMESTAMP WITH LOCAL TIME ZONE: " + clazz);
            }
            case ARRAY: {
                if (clazz == ArrayData.class) {
                    return ArrayDataConverter.INSTANCE;
                }
                if (clazz == boolean[].class) {
                    return PrimitiveBooleanArrayConverter.INSTANCE;
                }
                if (clazz == short[].class) {
                    return PrimitiveShortArrayConverter.INSTANCE;
                }
                if (clazz == int[].class) {
                    return PrimitiveIntArrayConverter.INSTANCE;
                }
                if (clazz == long[].class) {
                    return PrimitiveLongArrayConverter.INSTANCE;
                }
                if (clazz == float[].class) {
                    return PrimitiveFloatArrayConverter.INSTANCE;
                }
                if (clazz == double[].class) {
                    return PrimitiveDoubleArrayConverter.INSTANCE;
                }
                if (dataType instanceof CollectionDataType) {
                    return new ObjectArrayConverter((DataType)((CollectionDataType)dataType).getElementDataType().bridgedTo(clazz.getComponentType()));
                }
                BasicArrayTypeInfo typeInfo = (BasicArrayTypeInfo)((LegacyTypeInformationType)dataType.getLogicalType()).getTypeInformation();
                return new ObjectArrayConverter((DataType)TypeConversions.fromLegacyInfoToDataType(typeInfo.getComponentInfo()).bridgedTo(clazz.getComponentType()));
            }
            case MAP: {
                if (clazz == MapData.class) {
                    return MapDataConverter.INSTANCE;
                }
                KeyValueDataType keyValueDataType = (KeyValueDataType)dataType;
                return new MapConverter(keyValueDataType.getKeyDataType(), keyValueDataType.getValueDataType());
            }
            case MULTISET: {
                if (clazz == MapData.class) {
                    return MapDataConverter.INSTANCE;
                }
                CollectionDataType collectionDataType = (CollectionDataType)dataType;
                return new MapConverter(collectionDataType.getElementDataType(), (DataType)DataTypes.INT().bridgedTo(Integer.class));
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                TypeInformation<?> asTypeInfo = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(dataType);
                if (asTypeInfo instanceof InternalTypeInfo && clazz == RowData.class) {
                    LogicalType realLogicalType = ((InternalTypeInfo)asTypeInfo).toLogicalType();
                    return new RowDataConverter(LogicalTypeChecks.getFieldCount(realLogicalType));
                }
                CompositeType compositeType = (CompositeType)asTypeInfo;
                DataType[] fieldTypes = (DataType[])Stream.iterate(0, x -> x + 1).limit(compositeType.getArity()).map(compositeType::getTypeAt).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new);
                if (clazz == RowData.class) {
                    return new RowDataConverter(compositeType.getArity());
                }
                if (clazz == Row.class) {
                    return new RowConverter(fieldTypes);
                }
                if (Tuple.class.isAssignableFrom(clazz)) {
                    return new TupleConverter(clazz, fieldTypes);
                }
                if (CaseClassConverter.PRODUCT_CLASS != null && CaseClassConverter.PRODUCT_CLASS.isAssignableFrom(clazz)) {
                    return new CaseClassConverter((TupleTypeInfoBase)compositeType, fieldTypes);
                }
                if (compositeType instanceof PojoTypeInfo) {
                    return new PojoConverter((PojoTypeInfo)compositeType, fieldTypes);
                }
                throw new IllegalStateException("Cannot find a converter for type " + compositeType + ". If the target should be a converter to scala.Product, then you might have a scala classpath issue.");
            }
            case RAW: {
                TypeInformation typeInfo;
                if (logicalType instanceof RawType) {
                    RawType rawType = (RawType)logicalType;
                    if (clazz == RawValueData.class) {
                        return RawValueDataConverter.INSTANCE;
                    }
                    return new GenericConverter(rawType.getTypeSerializer());
                }
                TypeInformation typeInformation = typeInfo = logicalType instanceof LegacyTypeInformationType ? ((LegacyTypeInformationType)logicalType).getTypeInformation() : ((TypeInformationRawType)logicalType).getTypeInformation();
                if (typeInfo instanceof StringDataTypeInfo) {
                    return StringDataConverter.INSTANCE;
                }
                if (typeInfo instanceof DecimalDataTypeInfo) {
                    DecimalDataTypeInfo decimalType = (DecimalDataTypeInfo)typeInfo;
                    return new DecimalDataConverter(decimalType.precision(), decimalType.scale());
                }
                if (typeInfo instanceof BigDecimalTypeInfo) {
                    BigDecimalTypeInfo decimalType = (BigDecimalTypeInfo)typeInfo;
                    return new BigDecimalConverter(decimalType.precision(), decimalType.scale());
                }
                if (typeInfo instanceof TimestampDataTypeInfo) {
                    TimestampDataTypeInfo timestampDataTypeInfo = (TimestampDataTypeInfo)typeInfo;
                    return new TimestampDataConverter(timestampDataTypeInfo.getPrecision());
                }
                if (typeInfo instanceof LegacyLocalDateTimeTypeInfo) {
                    LegacyLocalDateTimeTypeInfo dateTimeType = (LegacyLocalDateTimeTypeInfo)typeInfo;
                    return new LocalDateTimeConverter(dateTimeType.getPrecision());
                }
                if (typeInfo instanceof LegacyTimestampTypeInfo) {
                    LegacyTimestampTypeInfo timestampType = (LegacyTimestampTypeInfo)typeInfo;
                    return new TimestampConverter(timestampType.getPrecision());
                }
                if (typeInfo instanceof LegacyInstantTypeInfo) {
                    LegacyInstantTypeInfo instantTypeInfo = (LegacyInstantTypeInfo)typeInfo;
                    return new InstantConverter(instantTypeInfo.getPrecision());
                }
                if (clazz == RawValueData.class) {
                    return RawValueDataConverter.INSTANCE;
                }
                return new GenericConverter(typeInfo.createSerializer(new ExecutionConfig()));
            }
        }
        throw new RuntimeException("Not support dataType: " + dataType);
    }

    private static Tuple2<Integer, Integer> getPrecision(LogicalType logicalType) {
        Tuple2<Integer, Integer> ps = new Tuple2<Integer, Integer>();
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            ps.f0 = decimalType.getPrecision();
            ps.f1 = decimalType.getScale();
        } else {
            TypeInformation typeInfo = ((LegacyTypeInformationType)logicalType).getTypeInformation();
            if (typeInfo instanceof BigDecimalTypeInfo) {
                BigDecimalTypeInfo decimalType = (BigDecimalTypeInfo)typeInfo;
                ps.f0 = decimalType.precision();
                ps.f1 = decimalType.scale();
            } else if (typeInfo instanceof DecimalDataTypeInfo) {
                DecimalDataTypeInfo decimalType = (DecimalDataTypeInfo)typeInfo;
                ps.f0 = decimalType.precision();
                ps.f1 = decimalType.scale();
            } else {
                ps.f0 = DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT.getPrecision();
                ps.f1 = DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT.getScale();
            }
        }
        return ps;
    }

    private static int getDateTimePrecision(LogicalType logicalType) {
        if (logicalType instanceof LocalZonedTimestampType) {
            return ((LocalZonedTimestampType)logicalType).getPrecision();
        }
        if (logicalType instanceof TimestampType) {
            return ((TimestampType)logicalType).getPrecision();
        }
        TypeInformation typeInfo = ((LegacyTypeInformationType)logicalType).getTypeInformation();
        if (typeInfo instanceof LegacyInstantTypeInfo) {
            return ((LegacyInstantTypeInfo)typeInfo).getPrecision();
        }
        if (typeInfo instanceof LegacyLocalDateTimeTypeInfo) {
            return ((LegacyLocalDateTimeTypeInfo)typeInfo).getPrecision();
        }
        return 6;
    }

    private static <T> T[] genericArrayToJavaArray(GenericArrayData value, LogicalType eleType) {
        if (value.isPrimitiveArray()) {
            switch (eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return ArrayUtils.toObject((boolean[])value.toBooleanArray());
                }
                case TINYINT: {
                    return ArrayUtils.toObject((byte[])value.toByteArray());
                }
                case SMALLINT: {
                    return ArrayUtils.toObject((short[])value.toShortArray());
                }
                case INTEGER: {
                    return ArrayUtils.toObject((int[])value.toIntArray());
                }
                case BIGINT: {
                    return ArrayUtils.toObject((long[])value.toLongArray());
                }
                case FLOAT: {
                    return ArrayUtils.toObject((float[])value.toFloatArray());
                }
                case DOUBLE: {
                    return ArrayUtils.toObject((double[])value.toDoubleArray());
                }
            }
            throw new RuntimeException("Not a primitive type: " + eleType);
        }
        return value.toObjectArray();
    }

    private static <T> T[] arrayDataToJavaArray(ArrayData value, ArrayData.ElementGetter elementGetter, Class<T> componentClass, DataFormatConverter<Object, T> elementConverter) {
        int size = value.size();
        Object[] values = (Object[])Array.newInstance(componentClass, size);
        for (int i = 0; i < size; ++i) {
            values[i] = value.isNullAt(i) ? null : elementConverter.toExternalImpl(elementGetter.getElementOrNull(value, i));
        }
        return values;
    }

    static {
        HashMap t2C = new HashMap();
        t2C.put(DataTypes.BOOLEAN().bridgedTo(Boolean.class), BooleanConverter.INSTANCE);
        t2C.put(DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE), BooleanConverter.INSTANCE);
        t2C.put(DataTypes.INT().bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.INT().bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.BIGINT().bridgedTo(Long.class), LongConverter.INSTANCE);
        t2C.put(DataTypes.BIGINT().bridgedTo(Long.TYPE), LongConverter.INSTANCE);
        t2C.put(DataTypes.SMALLINT().bridgedTo(Short.class), ShortConverter.INSTANCE);
        t2C.put(DataTypes.SMALLINT().bridgedTo(Short.TYPE), ShortConverter.INSTANCE);
        t2C.put(DataTypes.FLOAT().bridgedTo(Float.class), FloatConverter.INSTANCE);
        t2C.put(DataTypes.FLOAT().bridgedTo(Float.TYPE), FloatConverter.INSTANCE);
        t2C.put(DataTypes.DOUBLE().bridgedTo(Double.class), DoubleConverter.INSTANCE);
        t2C.put(DataTypes.DOUBLE().bridgedTo(Double.TYPE), DoubleConverter.INSTANCE);
        t2C.put(DataTypes.TINYINT().bridgedTo(Byte.class), ByteConverter.INSTANCE);
        t2C.put(DataTypes.TINYINT().bridgedTo(Byte.TYPE), ByteConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(Date.class), DateConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(LocalDate.class), LocalDateConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(Time.class), TimeConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(LocalTime.class), LocalTimeConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL(DataTypes.MONTH()).bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL(DataTypes.MONTH()).bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL(DataTypes.SECOND(3)).bridgedTo(Long.class), LongConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL(DataTypes.SECOND(3)).bridgedTo(Long.TYPE), LongConverter.INSTANCE);
        TYPE_TO_CONVERTER = Collections.unmodifiableMap(t2C);
    }

    public static final class TimestampDataConverter
    extends IdentityConverter<TimestampData> {
        private static final long serialVersionUID = 1L;
        private final int precision;

        public TimestampDataConverter(int precision) {
            this.precision = precision;
        }

        @Override
        TimestampData toExternalImpl(RowData row, int column) {
            return row.getTimestamp(column, this.precision);
        }
    }

    public static final class LongTimestampDataConverter
    extends DataFormatConverter<TimestampData, Long> {
        private static final long serialVersionUID = 1L;
        private final int precision;

        public LongTimestampDataConverter(int precision) {
            this.precision = precision;
        }

        @Override
        TimestampData toInternalImpl(Long value) {
            return TimestampData.fromEpochMillis(value);
        }

        @Override
        Long toExternalImpl(TimestampData value) {
            return value.getMillisecond();
        }

        @Override
        Long toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getTimestamp(column, this.precision));
        }
    }

    public static final class CaseClassConverter
    extends AbstractRowDataConverter<Object> {
        private static final long serialVersionUID = -966598627968372952L;
        @Nullable
        private static final Class<?> PRODUCT_CLASS = CaseClassConverter.getProductClass();
        @Nullable
        private static final Method PRODUCT_ELEMENT_METHOD = CaseClassConverter.getProductElementMethod();
        private final TupleTypeInfoBase t;
        private final TupleSerializerBase serializer;

        public CaseClassConverter(TupleTypeInfoBase t, DataType[] fieldTypes) {
            super(fieldTypes);
            this.t = t;
            this.serializer = (TupleSerializerBase)t.createSerializer(new ExecutionConfig());
        }

        @Override
        RowData toInternalImpl(Object value) {
            GenericRowData genericRow = new GenericRowData(this.t.getArity());
            for (int i = 0; i < this.t.getArity(); ++i) {
                genericRow.setField(i, this.converters[i].toInternal(CaseClassConverter.invokeProductElement(value, i)));
            }
            return genericRow;
        }

        @Override
        Object toExternalImpl(RowData value) {
            Object[] fields = new Object[this.t.getArity()];
            for (int i = 0; i < this.t.getArity(); ++i) {
                fields[i] = this.converters[i].toExternal(value, i);
            }
            return this.serializer.createInstance(fields);
        }

        private static Class<?> getProductClass() {
            try {
                return Class.forName("scala.Product", false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static Method getProductElementMethod() {
            try {
                if (PRODUCT_CLASS == null) {
                    return null;
                }
                return PRODUCT_CLASS.getMethod("productElement", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find scala.Product#productElement, has Scala changed its public API?", e);
            }
        }

        private static Object invokeProductElement(Object value, int i) {
            try {
                if (PRODUCT_ELEMENT_METHOD == null) {
                    throw new IllegalStateException("PRODUCT_ELEMENT_METHOD is null, but it cannot be as this method should never be invoked if Scala is not in the classpath. Something is wrong with the classpath?");
                }
                return PRODUCT_ELEMENT_METHOD.invoke(value, i);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot execute scala.Product#productElement, has Scala changed its public API?", e);
            }
        }
    }

    public static final class TupleConverter
    extends AbstractRowDataConverter<Tuple> {
        private static final long serialVersionUID = 2794892691010934194L;
        private final Class<Tuple> clazz;

        public TupleConverter(Class<Tuple> clazz, DataType[] fieldTypes) {
            super(fieldTypes);
            this.clazz = clazz;
        }

        @Override
        RowData toInternalImpl(Tuple value) {
            GenericRowData genericRow = new GenericRowData(this.converters.length);
            for (int i = 0; i < this.converters.length; ++i) {
                genericRow.setField(i, this.converters[i].toInternal(value.getField(i)));
            }
            return genericRow;
        }

        @Override
        Tuple toExternalImpl(RowData value) {
            try {
                Tuple tuple = this.clazz.newInstance();
                for (int i = 0; i < this.converters.length; ++i) {
                    tuple.setField(this.converters[i].toExternal(value, i), i);
                }
                return tuple;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class RowConverter
    extends AbstractRowDataConverter<Row> {
        private static final long serialVersionUID = -56553502075225785L;

        public RowConverter(DataType[] fieldTypes) {
            super(fieldTypes);
        }

        @Override
        RowData toInternalImpl(Row value) {
            GenericRowData genericRow = new GenericRowData(value.getKind(), this.converters.length);
            for (int i = 0; i < this.converters.length; ++i) {
                genericRow.setField(i, this.converters[i].toInternal(value.getField(i)));
            }
            return genericRow;
        }

        @Override
        Row toExternalImpl(RowData value) {
            Row row = new Row(value.getRowKind(), this.converters.length);
            for (int i = 0; i < this.converters.length; ++i) {
                row.setField(i, this.converters[i].toExternal(value, i));
            }
            return row;
        }
    }

    public static final class PojoConverter<T>
    extends AbstractRowDataConverter<T> {
        private static final long serialVersionUID = 6821541780176167135L;
        private final PojoTypeInfo<T> t;
        private final PojoField[] fields;

        public PojoConverter(PojoTypeInfo<T> t, DataType[] fieldTypes) {
            super(fieldTypes);
            this.fields = new PojoField[t.getArity()];
            for (int i = 0; i < t.getArity(); ++i) {
                this.fields[i] = t.getPojoFieldAt(i);
                this.fields[i].getField().setAccessible(true);
            }
            this.t = t;
        }

        @Override
        RowData toInternalImpl(T value) {
            GenericRowData genericRow = new GenericRowData(this.t.getArity());
            for (int i = 0; i < this.t.getArity(); ++i) {
                try {
                    genericRow.setField(i, this.converters[i].toInternal(this.fields[i].getField().get(value)));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return genericRow;
        }

        @Override
        T toExternalImpl(RowData value) {
            try {
                Object pojo = this.t.getTypeClass().newInstance();
                for (int i = 0; i < this.t.getArity(); ++i) {
                    this.fields[i].getField().set(pojo, this.converters[i].toExternal(value, i));
                }
                return pojo;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class RowDataConverter
    extends IdentityConverter<RowData> {
        private static final long serialVersionUID = -4470307402371540680L;
        private int arity;

        private RowDataConverter(int arity) {
            this.arity = arity;
        }

        @Override
        RowData toExternalImpl(RowData row, int column) {
            return row.getRow(column, this.arity);
        }
    }

    public static abstract class AbstractRowDataConverter<E>
    extends DataFormatConverter<RowData, E> {
        private static final long serialVersionUID = 4365740929854771618L;
        protected final DataFormatConverter[] converters;

        public AbstractRowDataConverter(DataType[] fieldTypes) {
            this.converters = new DataFormatConverter[fieldTypes.length];
            for (int i = 0; i < this.converters.length; ++i) {
                this.converters[i] = DataFormatConverters.getConverterForDataType(fieldTypes[i]);
            }
        }

        @Override
        E toExternalImpl(RowData row, int column) {
            return (E)this.toExternalImpl(row.getRow(column, this.converters.length));
        }
    }

    public static final class MapConverter
    extends DataFormatConverter<MapData, Map> {
        private static final long serialVersionUID = -916429669828309919L;
        private final LogicalType keyType;
        private final LogicalType valueType;
        private final DataFormatConverter keyConverter;
        private final DataFormatConverter valueConverter;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;
        private final int keyElementSize;
        private final int valueElementSize;
        private final Class keyComponentClass;
        private final Class valueComponentClass;
        private final TypeSerializer keySer;
        private final TypeSerializer valueSer;
        private final boolean isKeyValueIndentity;
        private transient BinaryArrayData reuseKArray;
        private transient BinaryArrayWriter reuseKWriter;
        private transient BinaryArrayData reuseVArray;
        private transient BinaryArrayWriter reuseVWriter;

        public MapConverter(DataType keyTypeInfo, DataType valueTypeInfo) {
            this.keyType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(keyTypeInfo);
            this.valueType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(valueTypeInfo);
            this.keyConverter = DataFormatConverters.getConverterForDataType(keyTypeInfo);
            this.valueConverter = DataFormatConverters.getConverterForDataType(valueTypeInfo);
            this.keyGetter = ArrayData.createElementGetter(this.keyType);
            this.valueGetter = ArrayData.createElementGetter(this.valueType);
            this.keyElementSize = BinaryArrayData.calculateFixLengthPartSize(this.keyType);
            this.valueElementSize = BinaryArrayData.calculateFixLengthPartSize(this.valueType);
            this.keyComponentClass = keyTypeInfo.getConversionClass();
            this.valueComponentClass = valueTypeInfo.getConversionClass();
            this.isKeyValueIndentity = this.keyConverter instanceof IdentityConverter && this.valueConverter instanceof IdentityConverter;
            this.keySer = InternalSerializers.create(this.keyType);
            this.valueSer = InternalSerializers.create(this.valueType);
        }

        @Override
        MapData toInternalImpl(Map value) {
            return this.isKeyValueIndentity ? new GenericMapData(value) : this.toBinaryMap(value);
        }

        private MapData toBinaryMap(Map value) {
            if (this.reuseKArray == null) {
                this.reuseKArray = new BinaryArrayData();
                this.reuseVArray = new BinaryArrayData();
            }
            if (this.reuseKWriter == null || this.reuseKWriter.getNumElements() != value.size()) {
                this.reuseKWriter = new BinaryArrayWriter(this.reuseKArray, value.size(), this.keyElementSize);
                this.reuseVWriter = new BinaryArrayWriter(this.reuseVArray, value.size(), this.valueElementSize);
            } else {
                this.reuseKWriter.reset();
                this.reuseVWriter.reset();
            }
            int i = 0;
            for (Map.Entry entry : value.entrySet()) {
                if (entry.getKey() == null) {
                    this.reuseKWriter.setNullAt(i, this.keyType);
                } else {
                    BinaryWriter.write(this.reuseKWriter, i, this.keyConverter.toInternalImpl(entry.getKey()), this.keyType, this.keySer);
                }
                if (entry.getValue() == null) {
                    this.reuseVWriter.setNullAt(i, this.valueType);
                } else {
                    BinaryWriter.write(this.reuseVWriter, i, this.valueConverter.toInternalImpl(entry.getValue()), this.valueType, this.valueSer);
                }
                ++i;
            }
            this.reuseKWriter.complete();
            this.reuseVWriter.complete();
            return BinaryMapData.valueOf(this.reuseKArray, this.reuseVArray);
        }

        @Override
        Map toExternalImpl(MapData map) {
            HashMap<Object, Object> javaMap = new HashMap<Object, Object>();
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            for (int i = 0; i < map.size(); ++i) {
                Object key = keyArray.isNullAt(i) ? null : (Object)this.keyConverter.toExternalImpl(this.keyGetter.getElementOrNull(keyArray, i));
                Object value = valueArray.isNullAt(i) ? null : (Object)this.valueConverter.toExternalImpl(this.valueGetter.getElementOrNull(valueArray, i));
                javaMap.put(key, value);
            }
            return javaMap;
        }

        @Override
        Map toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getMap(column));
        }
    }

    public static final class ObjectArrayConverter<T>
    extends DataFormatConverter<ArrayData, T[]> {
        private static final long serialVersionUID = -7434682160639380078L;
        private final Class<T> componentClass;
        private final LogicalType elementType;
        private final ArrayData.ElementGetter elementGetter;
        private final DataFormatConverter<Object, T> elementConverter;
        private final int elementSize;
        private final TypeSerializer<T> eleSer;
        private final boolean isEleIndentity;
        private transient BinaryArrayData reuseArray;
        private transient BinaryArrayWriter reuseWriter;

        public ObjectArrayConverter(DataType elementType) {
            this.componentClass = elementType.getConversionClass();
            this.elementType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(elementType);
            this.elementGetter = ArrayData.createElementGetter(this.elementType);
            this.elementConverter = DataFormatConverters.getConverterForDataType(elementType);
            this.elementSize = BinaryArrayData.calculateFixLengthPartSize(this.elementType);
            this.eleSer = InternalSerializers.create(this.elementType);
            this.isEleIndentity = this.elementConverter instanceof IdentityConverter;
        }

        @Override
        ArrayData toInternalImpl(T[] value) {
            return this.isEleIndentity ? new GenericArrayData(value) : this.toBinaryArray(value);
        }

        private ArrayData toBinaryArray(T[] value) {
            if (this.reuseArray == null) {
                this.reuseArray = new BinaryArrayData();
            }
            if (this.reuseWriter == null || this.reuseWriter.getNumElements() != value.length) {
                this.reuseWriter = new BinaryArrayWriter(this.reuseArray, value.length, this.elementSize);
            } else {
                this.reuseWriter.reset();
            }
            for (int i = 0; i < value.length; ++i) {
                T field = value[i];
                if (field == null) {
                    this.reuseWriter.setNullAt(i, this.elementType);
                    continue;
                }
                BinaryWriter.write(this.reuseWriter, i, this.elementConverter.toInternalImpl(value[i]), this.elementType, this.eleSer);
            }
            this.reuseWriter.complete();
            return this.reuseArray.copy();
        }

        @Override
        T[] toExternalImpl(ArrayData value) {
            return this.isEleIndentity && value instanceof GenericArrayData ? DataFormatConverters.genericArrayToJavaArray((GenericArrayData)value, this.elementType) : DataFormatConverters.arrayDataToJavaArray(value, this.elementGetter, this.componentClass, this.elementConverter);
        }

        @Override
        T[] toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveDoubleArrayConverter
    extends DataFormatConverter<ArrayData, double[]> {
        private static final long serialVersionUID = 6333670535356315691L;
        public static final PrimitiveDoubleArrayConverter INSTANCE = new PrimitiveDoubleArrayConverter();

        private PrimitiveDoubleArrayConverter() {
        }

        @Override
        ArrayData toInternalImpl(double[] value) {
            return new GenericArrayData(value);
        }

        @Override
        double[] toExternalImpl(ArrayData value) {
            return value.toDoubleArray();
        }

        @Override
        double[] toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveFloatArrayConverter
    extends DataFormatConverter<ArrayData, float[]> {
        private static final long serialVersionUID = -3237695040861141459L;
        public static final PrimitiveFloatArrayConverter INSTANCE = new PrimitiveFloatArrayConverter();

        private PrimitiveFloatArrayConverter() {
        }

        @Override
        ArrayData toInternalImpl(float[] value) {
            return new GenericArrayData(value);
        }

        @Override
        float[] toExternalImpl(ArrayData value) {
            return value.toFloatArray();
        }

        @Override
        float[] toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveLongArrayConverter
    extends DataFormatConverter<ArrayData, long[]> {
        private static final long serialVersionUID = 4061982985342526078L;
        public static final PrimitiveLongArrayConverter INSTANCE = new PrimitiveLongArrayConverter();

        private PrimitiveLongArrayConverter() {
        }

        @Override
        ArrayData toInternalImpl(long[] value) {
            return new GenericArrayData(value);
        }

        @Override
        long[] toExternalImpl(ArrayData value) {
            return value.toLongArray();
        }

        @Override
        long[] toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveShortArrayConverter
    extends DataFormatConverter<ArrayData, short[]> {
        private static final long serialVersionUID = -1343184089311186834L;
        public static final PrimitiveShortArrayConverter INSTANCE = new PrimitiveShortArrayConverter();

        private PrimitiveShortArrayConverter() {
        }

        @Override
        ArrayData toInternalImpl(short[] value) {
            return new GenericArrayData(value);
        }

        @Override
        short[] toExternalImpl(ArrayData value) {
            return value.toShortArray();
        }

        @Override
        short[] toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveByteArrayConverter
    extends IdentityConverter<byte[]> {
        private static final long serialVersionUID = -2007960927801689921L;
        public static final PrimitiveByteArrayConverter INSTANCE = new PrimitiveByteArrayConverter();

        private PrimitiveByteArrayConverter() {
        }

        @Override
        byte[] toExternalImpl(RowData row, int column) {
            return row.getBinary(column);
        }
    }

    public static final class PrimitiveBooleanArrayConverter
    extends DataFormatConverter<ArrayData, boolean[]> {
        private static final long serialVersionUID = -4037693692440282141L;
        public static final PrimitiveBooleanArrayConverter INSTANCE = new PrimitiveBooleanArrayConverter();

        private PrimitiveBooleanArrayConverter() {
        }

        @Override
        ArrayData toInternalImpl(boolean[] value) {
            return new GenericArrayData(value);
        }

        @Override
        boolean[] toExternalImpl(ArrayData value) {
            return value.toBooleanArray();
        }

        @Override
        boolean[] toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveIntArrayConverter
    extends DataFormatConverter<ArrayData, int[]> {
        private static final long serialVersionUID = 1780941126232395638L;
        public static final PrimitiveIntArrayConverter INSTANCE = new PrimitiveIntArrayConverter();

        private PrimitiveIntArrayConverter() {
        }

        @Override
        ArrayData toInternalImpl(int[] value) {
            return new GenericArrayData(value);
        }

        @Override
        int[] toExternalImpl(ArrayData value) {
            return value.toIntArray();
        }

        @Override
        int[] toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class TimestampLtzConverter
    extends DataFormatConverter<TimestampData, Timestamp> {
        private static final long serialVersionUID = 1L;
        private static final int NANOS_PER_MILL = 1000000;
        private final int precision;

        public TimestampLtzConverter(int precision) {
            this.precision = precision;
        }

        @Override
        TimestampData toInternalImpl(Timestamp value) {
            return TimestampData.fromEpochMillis(value.getTime(), value.getNanos() % 1000000);
        }

        @Override
        Timestamp toExternalImpl(TimestampData value) {
            Timestamp ts = new Timestamp(value.getMillisecond());
            ts.setNanos(ts.getNanos() + value.getNanoOfMillisecond());
            return ts;
        }

        @Override
        Timestamp toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getTimestamp(column, this.precision));
        }
    }

    public static final class TimestampConverter
    extends DataFormatConverter<TimestampData, Timestamp> {
        private static final long serialVersionUID = -779956524906131757L;
        private final int precision;

        public TimestampConverter(int precision) {
            this.precision = precision;
        }

        @Override
        TimestampData toInternalImpl(Timestamp value) {
            return TimestampData.fromTimestamp(value);
        }

        @Override
        Timestamp toExternalImpl(TimestampData value) {
            return value.toTimestamp();
        }

        @Override
        Timestamp toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getTimestamp(column, this.precision));
        }
    }

    public static final class TimeConverter
    extends DataFormatConverter<Integer, Time> {
        private static final long serialVersionUID = -8061475784916442483L;
        public static final TimeConverter INSTANCE = new TimeConverter();

        private TimeConverter() {
        }

        @Override
        Integer toInternalImpl(Time value) {
            return DateTimeUtils.toInternal(value);
        }

        @Override
        Time toExternalImpl(Integer value) {
            return DateTimeUtils.toSQLTime(value);
        }

        @Override
        Time toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class DateConverter
    extends DataFormatConverter<Integer, Date> {
        private static final long serialVersionUID = 1343457113582411650L;
        public static final DateConverter INSTANCE = new DateConverter();

        private DateConverter() {
        }

        @Override
        Integer toInternalImpl(Date value) {
            return DateTimeUtils.toInternal(value);
        }

        @Override
        Date toExternalImpl(Integer value) {
            return DateTimeUtils.toSQLDate(value);
        }

        @Override
        Date toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class InstantConverter
    extends DataFormatConverter<TimestampData, Instant> {
        private static final long serialVersionUID = 1L;
        private final int precision;

        public InstantConverter(int precision) {
            this.precision = precision;
        }

        @Override
        TimestampData toInternalImpl(Instant value) {
            return TimestampData.fromInstant(value);
        }

        @Override
        Instant toExternalImpl(TimestampData value) {
            return value.toInstant();
        }

        @Override
        Instant toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getTimestamp(column, this.precision));
        }
    }

    public static final class LocalDateTimeConverter
    extends DataFormatConverter<TimestampData, LocalDateTime> {
        private static final long serialVersionUID = 1L;
        private final int precision;

        public LocalDateTimeConverter(int precision) {
            this.precision = precision;
        }

        @Override
        TimestampData toInternalImpl(LocalDateTime value) {
            return TimestampData.fromLocalDateTime(value);
        }

        @Override
        LocalDateTime toExternalImpl(TimestampData value) {
            return value.toLocalDateTime();
        }

        @Override
        LocalDateTime toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getTimestamp(column, this.precision));
        }
    }

    public static final class LocalTimeConverter
    extends DataFormatConverter<Integer, LocalTime> {
        private static final long serialVersionUID = 1L;
        public static final LocalTimeConverter INSTANCE = new LocalTimeConverter();

        private LocalTimeConverter() {
        }

        @Override
        Integer toInternalImpl(LocalTime value) {
            return DateTimeUtils.toInternal(value);
        }

        @Override
        LocalTime toExternalImpl(Integer value) {
            return DateTimeUtils.toLocalTime(value);
        }

        @Override
        LocalTime toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class LocalDateConverter
    extends DataFormatConverter<Integer, LocalDate> {
        private static final long serialVersionUID = 1L;
        public static final LocalDateConverter INSTANCE = new LocalDateConverter();

        private LocalDateConverter() {
        }

        @Override
        Integer toInternalImpl(LocalDate value) {
            return DateTimeUtils.toInternal(value);
        }

        @Override
        LocalDate toExternalImpl(Integer value) {
            return DateTimeUtils.toLocalDate(value);
        }

        @Override
        LocalDate toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class GenericConverter<T>
    extends DataFormatConverter<RawValueData<T>, T> {
        private static final long serialVersionUID = -3611718364918053384L;
        private final TypeSerializer<T> serializer;

        public GenericConverter(TypeSerializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        RawValueData<T> toInternalImpl(T value) {
            return RawValueData.fromObject(value);
        }

        @Override
        T toExternalImpl(RawValueData<T> value) {
            return value.toObject(this.serializer);
        }

        @Override
        T toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getRawValue(column));
        }
    }

    public static final class BigDecimalConverter
    extends DataFormatConverter<DecimalData, BigDecimal> {
        private static final long serialVersionUID = -6586239704060565834L;
        private final int precision;
        private final int scale;

        public BigDecimalConverter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        DecimalData toInternalImpl(BigDecimal value) {
            return DecimalData.fromBigDecimal(value, this.precision, this.scale);
        }

        @Override
        BigDecimal toExternalImpl(DecimalData value) {
            return value.toBigDecimal();
        }

        @Override
        BigDecimal toExternalImpl(RowData row, int column) {
            return this.toExternalImpl(row.getDecimal(column, this.precision, this.scale));
        }
    }

    public static final class StringConverter
    extends DataFormatConverter<StringData, String> {
        private static final long serialVersionUID = 4713165079099282774L;
        public static final StringConverter INSTANCE = new StringConverter();

        private StringConverter() {
        }

        @Override
        StringData toInternalImpl(String value) {
            return StringData.fromString(value);
        }

        @Override
        String toExternalImpl(StringData value) {
            return value.toString();
        }

        @Override
        String toExternalImpl(RowData row, int column) {
            return row.getString(column).toString();
        }
    }

    public static final class RawValueDataConverter
    extends IdentityConverter<RawValueData<?>> {
        private static final long serialVersionUID = 1436229503920584273L;
        public static final RawValueDataConverter INSTANCE = new RawValueDataConverter();

        private RawValueDataConverter() {
        }

        @Override
        RawValueData<?> toExternalImpl(RowData row, int column) {
            return row.getRawValue(column);
        }
    }

    public static final class DecimalDataConverter
    extends IdentityConverter<DecimalData> {
        private static final long serialVersionUID = 3825744951173809617L;
        private final int precision;
        private final int scale;

        public DecimalDataConverter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        DecimalData toExternalImpl(RowData row, int column) {
            return row.getDecimal(column, this.precision, this.scale);
        }
    }

    public static final class MapDataConverter
    extends IdentityConverter<MapData> {
        private static final long serialVersionUID = -9114231688474126815L;
        public static final MapDataConverter INSTANCE = new MapDataConverter();

        private MapDataConverter() {
        }

        @Override
        MapData toExternalImpl(RowData row, int column) {
            return row.getMap(column);
        }
    }

    public static final class ArrayDataConverter
    extends IdentityConverter<ArrayData> {
        private static final long serialVersionUID = -7790350668043604641L;
        public static final ArrayDataConverter INSTANCE = new ArrayDataConverter();

        private ArrayDataConverter() {
        }

        @Override
        ArrayData toExternalImpl(RowData row, int column) {
            return row.getArray(column);
        }
    }

    public static final class StringDataConverter
    extends IdentityConverter<StringData> {
        private static final long serialVersionUID = 5565684451615599206L;
        public static final StringDataConverter INSTANCE = new StringDataConverter();

        private StringDataConverter() {
        }

        @Override
        StringData toExternalImpl(RowData row, int column) {
            return row.getString(column);
        }
    }

    public static final class DoubleConverter
    extends IdentityConverter<Double> {
        private static final long serialVersionUID = 2801171640313215040L;
        public static final DoubleConverter INSTANCE = new DoubleConverter();

        private DoubleConverter() {
        }

        @Override
        Double toExternalImpl(RowData row, int column) {
            return row.getDouble(column);
        }
    }

    public static final class FloatConverter
    extends IdentityConverter<Float> {
        private static final long serialVersionUID = -1119035126939832966L;
        public static final FloatConverter INSTANCE = new FloatConverter();

        private FloatConverter() {
        }

        @Override
        Float toExternalImpl(RowData row, int column) {
            return Float.valueOf(row.getFloat(column));
        }
    }

    public static final class LongConverter
    extends IdentityConverter<Long> {
        private static final long serialVersionUID = 7373868336730797650L;
        public static final LongConverter INSTANCE = new LongConverter();

        private LongConverter() {
        }

        @Override
        Long toExternalImpl(RowData row, int column) {
            return row.getLong(column);
        }
    }

    public static final class IntConverter
    extends IdentityConverter<Integer> {
        private static final long serialVersionUID = -7749307898273403416L;
        public static final IntConverter INSTANCE = new IntConverter();

        private IntConverter() {
        }

        @Override
        Integer toExternalImpl(RowData row, int column) {
            return row.getInt(column);
        }
    }

    public static final class ShortConverter
    extends IdentityConverter<Short> {
        private static final long serialVersionUID = 8055034507232206636L;
        public static final ShortConverter INSTANCE = new ShortConverter();

        private ShortConverter() {
        }

        @Override
        Short toExternalImpl(RowData row, int column) {
            return row.getShort(column);
        }
    }

    public static final class ByteConverter
    extends IdentityConverter<Byte> {
        private static final long serialVersionUID = 1880134895918999433L;
        public static final ByteConverter INSTANCE = new ByteConverter();

        private ByteConverter() {
        }

        @Override
        Byte toExternalImpl(RowData row, int column) {
            return row.getByte(column);
        }
    }

    public static final class BooleanConverter
    extends IdentityConverter<Boolean> {
        private static final long serialVersionUID = 3618373319753553272L;
        public static final BooleanConverter INSTANCE = new BooleanConverter();

        private BooleanConverter() {
        }

        @Override
        Boolean toExternalImpl(RowData row, int column) {
            return row.getBoolean(column);
        }
    }

    public static abstract class IdentityConverter<T>
    extends DataFormatConverter<T, T> {
        private static final long serialVersionUID = 6146619729108124872L;

        @Override
        T toInternalImpl(T value) {
            return value;
        }

        @Override
        T toExternalImpl(T value) {
            return value;
        }
    }

    public static abstract class DataFormatConverter<Internal, External>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public final Internal toInternal(External value) {
            return value == null ? null : (Internal)this.toInternalImpl(value);
        }

        abstract Internal toInternalImpl(External var1);

        public final External toExternal(Internal value) {
            return value == null ? null : (External)this.toExternalImpl(value);
        }

        abstract External toExternalImpl(Internal var1);

        abstract External toExternalImpl(RowData var1, int var2);

        public final External toExternal(RowData row, int column) {
            return row.isNullAt(column) ? null : (External)this.toExternalImpl(row, column);
        }
    }
}

