/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class HiveConfUtil {
    public static boolean isEmbeddedMetaStore(String msUri) {
        return msUri == null ? true : msUri.trim().isEmpty();
    }

    public static StringBuilder dumpConfig(HiveConf conf) {
        StringBuilder sb = new StringBuilder("START========\"HiveConf()\"========\n");
        sb.append("hiveDefaultUrl=").append(conf.getHiveDefaultLocation()).append('\n');
        sb.append("hiveSiteURL=").append(HiveConf.getHiveSiteLocation()).append('\n');
        sb.append("hiveServer2SiteUrl=").append(HiveConf.getHiveServer2SiteLocation()).append('\n');
        sb.append("hivemetastoreSiteUrl=").append(HiveConf.getMetastoreSiteLocation()).append('\n');
        HiveConfUtil.dumpConfig(conf, sb);
        return sb.append("END========\"new HiveConf()\"========\n");
    }

    public static Set<String> getHiddenSet(Configuration configuration) {
        HashSet<String> hiddenSet = new HashSet<String>();
        String hiddenListStr = HiveConf.getVar(configuration, HiveConf.ConfVars.HIVE_CONF_HIDDEN_LIST);
        if (hiddenListStr != null) {
            for (String entry : hiddenListStr.split(",")) {
                hiddenSet.add(entry.trim());
            }
        }
        return hiddenSet;
    }

    public static void stripConfigurations(Configuration conf, Set<String> hiddenSet) {
        for (String name : hiddenSet) {
            if (conf.get(name) == null) continue;
            conf.set(name, "");
        }
    }

    public static void dumpConfig(Configuration originalConf, StringBuilder sb) {
        Set<String> hiddenSet = HiveConfUtil.getHiddenSet(originalConf);
        sb.append("Values omitted for security reason if present: ").append(hiddenSet).append("\n");
        Configuration conf = new Configuration(originalConf);
        HiveConfUtil.stripConfigurations(conf, hiddenSet);
        Iterator configIter = conf.iterator();
        ArrayList configVals = new ArrayList();
        while (configIter.hasNext()) {
            configVals.add(configIter.next());
        }
        Collections.sort(configVals, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> ent, Map.Entry<String, String> ent2) {
                return ent.getKey().compareTo(ent2.getKey());
            }
        });
        for (Map.Entry entry : configVals) {
            if (((String)entry.getKey()).toLowerCase().contains("path")) {
                StringTokenizer st = new StringTokenizer(conf.get((String)entry.getKey()), File.pathSeparator);
                sb.append((String)entry.getKey()).append("=\n");
                while (st.hasMoreTokens()) {
                    sb.append("    ").append(st.nextToken()).append(File.pathSeparator).append('\n');
                }
                continue;
            }
            sb.append((String)entry.getKey()).append('=').append(conf.get((String)entry.getKey())).append('\n');
        }
    }
}

