/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ShareGroupDescription;
import org.apache.kafka.clients.admin.ShareMemberAssignment;
import org.apache.kafka.clients.admin.ShareMemberDescription;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.AdminUtils;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.message.ShareGroupDescribeRequestData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.ShareGroupDescribeRequest;
import org.apache.kafka.common.requests.ShareGroupDescribeResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class DescribeShareGroupsHandler
extends AdminApiHandler.Batched<CoordinatorKey, ShareGroupDescription> {
    private final boolean includeAuthorizedOperations;
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public DescribeShareGroupsHandler(boolean includeAuthorizedOperations, LogContext logContext) {
        this.includeAuthorizedOperations = includeAuthorizedOperations;
        this.log = logContext.logger(DescribeShareGroupsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    private static Set<CoordinatorKey> buildKeySet(Collection<String> groupIds) {
        return groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, ShareGroupDescription> newFuture(Collection<String> groupIds) {
        return AdminApiFuture.forKeys(DescribeShareGroupsHandler.buildKeySet(groupIds));
    }

    @Override
    public String apiName() {
        return "describeShareGroups";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public ShareGroupDescribeRequest.Builder buildBatchedRequest(int coordinatorId, Set<CoordinatorKey> keys) {
        List<String> groupIds = keys.stream().map(key -> {
            if (key.type != FindCoordinatorRequest.CoordinatorType.GROUP) {
                throw new IllegalArgumentException("Invalid group coordinator key " + String.valueOf(key) + " when building `DescribeShareGroups` request");
            }
            return key.idValue;
        }).collect(Collectors.toList());
        ShareGroupDescribeRequestData data = new ShareGroupDescribeRequestData().setGroupIds(groupIds).setIncludeAuthorizedOperations(this.includeAuthorizedOperations);
        return new ShareGroupDescribeRequest.Builder(data, true);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, ShareGroupDescription> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        ShareGroupDescribeResponse response = (ShareGroupDescribeResponse)abstractResponse;
        HashMap<CoordinatorKey, ShareGroupDescription> completed = new HashMap<CoordinatorKey, ShareGroupDescription>();
        HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
        HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
        for (ShareGroupDescribeResponseData.DescribedGroup describedGroup : response.data().groups()) {
            CoordinatorKey groupIdKey = CoordinatorKey.byGroupId(describedGroup.groupId());
            Errors error = Errors.forCode(describedGroup.errorCode());
            if (error != Errors.NONE) {
                this.handleError(groupIdKey, describedGroup, coordinator, error, describedGroup.errorMessage(), completed, failed, groupsToUnmap);
                continue;
            }
            ArrayList<ShareMemberDescription> memberDescriptions = new ArrayList<ShareMemberDescription>(describedGroup.members().size());
            Set<AclOperation> authorizedOperations = AdminUtils.validAclOperations(describedGroup.authorizedOperations());
            describedGroup.members().forEach(groupMember -> memberDescriptions.add(new ShareMemberDescription(groupMember.memberId(), groupMember.clientId(), groupMember.clientHost(), new ShareMemberAssignment(this.convertAssignment(groupMember.assignment())))));
            ShareGroupDescription shareGroupDescription = new ShareGroupDescription(groupIdKey.idValue, memberDescriptions, GroupState.parse(describedGroup.groupState()), coordinator, authorizedOperations);
            completed.put(groupIdKey, shareGroupDescription);
        }
        return new AdminApiHandler.ApiResult<CoordinatorKey, ShareGroupDescription>(completed, failed, new ArrayList(groupsToUnmap));
    }

    private Set<TopicPartition> convertAssignment(ShareGroupDescribeResponseData.Assignment assignment) {
        return assignment.topicPartitions().stream().flatMap(topic -> topic.partitions().stream().map(partition -> new TopicPartition(topic.topicName(), (int)partition))).collect(Collectors.toSet());
    }

    private void handleError(CoordinatorKey groupId, ShareGroupDescribeResponseData.DescribedGroup describedGroup, Node coordinator, Errors error, String errorMsg, Map<CoordinatorKey, ShareGroupDescription> completed, Map<CoordinatorKey, Throwable> failed, Set<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("`DescribeShareGroups` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception(errorMsg));
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`DescribeShareGroups` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`DescribeShareGroups` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            case GROUP_ID_NOT_FOUND: {
                this.log.debug("`DescribeShareGroups` request for group id {} failed because the group does not exist. {}", (Object)groupId.idValue, (Object)(errorMsg != null ? errorMsg : ""));
                failed.put(groupId, error.exception(errorMsg));
                break;
            }
            default: {
                this.log.error("`DescribeShareGroups` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception(errorMsg));
            }
        }
    }
}

