/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fields<T> {
    private Class<? extends T> type;
    private Class<?> clazz;
    private Object object;
    private Map<String, Field> fields;

    public Collection<T> get() {
        return this.map().values();
    }

    public Map<Field, T> map(Object o) {
        this.object = o;
        return this.map();
    }

    public Map<Field, T> map() {
        Collection<Field> set = this.retrieve();
        LinkedHashMap<Field, Object> results = new LinkedHashMap<Field, Object>();
        for (Field field : set) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                results.put(field, field.get(this.object));
            }
            catch (IllegalAccessException e) {}
        }
        return results;
    }

    public Collection<T> get(Object o) {
        this.object = o;
        return this.get();
    }

    public Fields ofType(Class<? extends T> clazz) {
        this.type = clazz;
        return this;
    }

    public Fields in(Object o) {
        this.object = o;
        this.clazz = o.getClass();
        return this;
    }

    public Fields in(Class<?> c) {
        this.clazz = c;
        return this;
    }

    private Collection<Field> retrieve() {
        Field[] list;
        if (this.fields != null) {
            return this.fields.values();
        }
        if (this.clazz == null) {
            throw new NullPointerException("Cannot retrieve field, class not set");
        }
        this.fields = new LinkedHashMap<String, Field>();
        for (Field field : list = this.clazz.getDeclaredFields()) {
            if (this.type != null && !this.type.isAssignableFrom(field.getType())) continue;
            this.fields.put(field.getName(), field);
        }
        if (this.clazz.getSuperclass() != null) {
            this.traverse(this.fields, this.clazz.getSuperclass());
        }
        return this.fields.values();
    }

    private void traverse(Map<String, Field> fields, Class<?> clazz) {
        Field[] list;
        for (Field field : list = clazz.getDeclaredFields()) {
            if (this.type != null && !this.type.isAssignableFrom(field.getType()) || fields.containsKey(field.getName()) || !Modifier.isPublic(field.getModifiers()) && !Modifier.isProtected(field.getModifiers())) continue;
            fields.put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null) {
            this.traverse(fields, clazz.getSuperclass());
        }
    }
}

