/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import javax.servlet.DispatcherType;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.dto.BuilderConstants;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;

public final class FilterDTOBuilder {
    @NotNull
    public static FilterDTO[] build(@NotNull FilterHandler[] handlers) {
        if (handlers.length == 0) {
            return BuilderConstants.EMPTY_FILTER_DTO_ARRAY;
        }
        FilterDTO[] array = new FilterDTO[handlers.length];
        for (int i = 0; i < handlers.length; ++i) {
            array[i] = FilterDTOBuilder.build(handlers[i], -1);
        }
        return array;
    }

    @NotNull
    public static FilterDTO build(@NotNull FilterHandler handler, int reason) {
        FilterDTO filterDTO = FilterDTOBuilder.build(handler.getFilterInfo(), reason);
        filterDTO.name = handler.getName();
        filterDTO.servletContextId = handler.getContextServiceId();
        return filterDTO;
    }

    @NotNull
    public static FilterDTO build(@NotNull FilterInfo info, int reason) {
        FilterDTO filterDTO = reason != -1 ? new FailedFilterDTO() : new FilterDTO();
        filterDTO.asyncSupported = info.isAsyncSupported();
        filterDTO.dispatcher = FilterDTOBuilder.getNames(info.getDispatcher());
        filterDTO.initParams = info.getInitParameters();
        filterDTO.name = info.getName();
        filterDTO.patterns = BuilderConstants.copyWithDefault(info.getPatterns(), BuilderConstants.EMPTY_STRING_ARRAY);
        filterDTO.regexs = BuilderConstants.copyWithDefault(info.getRegexs(), BuilderConstants.EMPTY_STRING_ARRAY);
        filterDTO.serviceId = info.getServiceId();
        filterDTO.servletNames = BuilderConstants.copyWithDefault(info.getServletNames(), BuilderConstants.EMPTY_STRING_ARRAY);
        if (reason != -1) {
            filterDTO.failureReason = reason;
        }
        return filterDTO;
    }

    @NotNull
    private static String[] getNames(@NotNull DispatcherType[] dispatcher) {
        String[] names = new String[dispatcher.length];
        for (int i = 0; i < dispatcher.length; ++i) {
            names[i] = dispatcher[i].name();
        }
        return names;
    }
}

