/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins;

import java.util.Map;
import org.apache.felix.atomos.utils.api.Config;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.RegisterServiceCall;
import org.apache.felix.atomos.utils.api.plugin.ComponentDescription;
import org.apache.felix.atomos.utils.api.plugin.ComponentMetaDataPlugin;
import org.apache.felix.atomos.utils.api.plugin.RegisterServicepPlugin;

public class GogoPlugin
implements ComponentMetaDataPlugin<Config>,
RegisterServicepPlugin<Config> {
    private static final String OSGI_COMMAND_FUNCTION = "osgi.command.function";

    private static void addMethodsFromGogoCommand(Class<?> clazz, String[] functions, Context context) {
        Class<?> tmpClass = clazz;
        for (String function : functions) {
            context.addReflectionMethod(function, tmpClass);
        }
        if ((tmpClass = tmpClass.getSuperclass()) != null && !tmpClass.equals(Object.class)) {
            GogoPlugin.addMethodsFromGogoCommand(tmpClass, functions, context);
        }
    }

    public void doComponentMetaData(ComponentDescription c, Context context, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(c.implementationClass());
            if (c.properties().containsKey(OSGI_COMMAND_FUNCTION)) {
                Object oFunctions = c.properties().get(OSGI_COMMAND_FUNCTION);
                String[] functions = null;
                functions = oFunctions instanceof String[] ? (String[])oFunctions : new String[]{oFunctions.toString()};
                GogoPlugin.addMethodsFromGogoCommand(clazz, functions, context);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void doRegisterServiceCall(RegisterServiceCall registerServiceCall, Context context, ClassLoader classLoader) {
        Map config = registerServiceCall.config();
        if (config.containsKey(OSGI_COMMAND_FUNCTION)) {
            String[] functions = (String[])config.get(OSGI_COMMAND_FUNCTION);
            GogoPlugin.addMethodsFromGogoCommand(registerServiceCall.service().getClass(), functions, context);
        }
    }

    public void init(Config config) {
        System.out.println("a");
    }
}

