/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.aci.ACIItemChecker;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class ACIItemSyntaxChecker
extends SyntaxChecker {
    private transient ACIItemChecker aciItemChecker;
    public static final ACIItemSyntaxChecker INSTANCE = new ACIItemSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.1", null);

    private ACIItemSyntaxChecker(String oid, SchemaManager schemaManager) {
        super(oid);
        this.aciItemChecker = new ACIItemChecker(schemaManager);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        try {
            ACIItemChecker aCIItemChecker = this.aciItemChecker;
            synchronized (aCIItemChecker) {
                this.aciItemChecker.parse(strValue);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
            }
            return true;
        }
        catch (ParseException pe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<ACIItemSyntaxChecker> {
        private SchemaManager schemaManager;

        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.1");
        }

        public Builder setSchemaManager(SchemaManager schemaManager) {
            this.schemaManager = schemaManager;
            return this;
        }

        @Override
        public ACIItemSyntaxChecker build() {
            return new ACIItemSyntaxChecker(this.oid, this.schemaManager);
        }
    }
}

