/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestContainer;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestStates;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SortRequestGrammar
extends AbstractGrammar<SortRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SortRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<SortRequestContainer> instance = new SortRequestGrammar();

    private SortRequestGrammar() {
        this.setName(SortRequestGrammar.class.getName());
        GrammarAction<SortRequestContainer> addSortKey = new GrammarAction<SortRequestContainer>(){

            public void action(SortRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String atDesc = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("AttributeTypeDesc = " + atDesc);
                }
                SortKey sk = new SortKey(atDesc);
                container.setCurrentKey(sk);
                container.getControl().addSortKey(sk);
                container.setGrammarEndAllowed(true);
            }
        };
        GrammarAction<SortRequestContainer> storeReverseOrder = new GrammarAction<SortRequestContainer>(){

            public void action(SortRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean reverseOrder = BooleanDecoder.parse((BerValue)value);
                    if (IS_DEBUG) {
                        LOG.debug("ReverseOrder = " + reverseOrder);
                    }
                    container.getCurrentKey().setReverseOrder(reverseOrder);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    throw new DecoderException(bde.getMessage(), (Throwable)bde);
                }
            }
        };
        this.transitions = new GrammarTransition[SortRequestStates.END_STATE.ordinal()][256];
        this.transitions[SortRequestStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SortRequestStates.START_STATE, (Enum)SortRequestStates.SEQUENCE_OF_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortRequestStates.SEQUENCE_OF_SEQUENCE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SortRequestStates.SEQUENCE_OF_SEQUENCE_STATE, (Enum)SortRequestStates.SORT_KEY_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortRequestStates.SORT_KEY_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SortRequestStates.SORT_KEY_SEQUENCE_STATE, (Enum)SortRequestStates.AT_DESC_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)addSortKey);
        this.transitions[SortRequestStates.AT_DESC_STATE.ordinal()][128] = new GrammarTransition((Enum)SortRequestStates.AT_DESC_STATE, (Enum)SortRequestStates.ORDER_RULE_STATE, 128, (Action)new GrammarAction<SortRequestContainer>(){

            public void action(SortRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String matchingRuleOid = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("MatchingRuleOid = " + matchingRuleOid);
                }
                container.getCurrentKey().setMatchingRuleId(matchingRuleOid);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SortRequestStates.ORDER_RULE_STATE.ordinal()][129] = new GrammarTransition((Enum)SortRequestStates.ORDER_RULE_STATE, (Enum)SortRequestStates.REVERSE_ORDER_STATE, 129, (Action)storeReverseOrder);
        this.transitions[SortRequestStates.AT_DESC_STATE.ordinal()][129] = new GrammarTransition((Enum)SortRequestStates.AT_DESC_STATE, (Enum)SortRequestStates.REVERSE_ORDER_STATE, 129, (Action)storeReverseOrder);
        this.transitions[SortRequestStates.REVERSE_ORDER_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SortRequestStates.REVERSE_ORDER_STATE, (Enum)SortRequestStates.SORT_KEY_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortRequestStates.AT_DESC_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SortRequestStates.AT_DESC_STATE, (Enum)SortRequestStates.SORT_KEY_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

