/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import org.apache.datasketches.frequencies.ReversePurgeLongHashMap;
import org.apache.datasketches.hash.MurmurHash3;

public class HashMapStressTest {
    public static void stress() {
        HashMapStressTest.println("ReversePurgeLongHashMap Stress Test");
        HashMapStressTest.printf("%12s%15s%n", "Capacity", "TimePerAdjust");
        for (int capacity = 64; capacity < 0x2000000; capacity *= 2) {
            int n = 10000000;
            long[] keys = new long[n];
            long[] values = new long[n];
            for (int i = 0; i < n; ++i) {
                keys[i] = HashMapStressTest.murmur(i);
                values[i] = i < capacity / 2 ? (long)n : 1L;
            }
            ReversePurgeLongHashMap hashmap = new ReversePurgeLongHashMap(capacity);
            long timePerAdjust = HashMapStressTest.timeOneHashMap(hashmap, keys, values, (int)(0.75 * (double)capacity));
            HashMapStressTest.printf("%12d%15d%n", capacity, timePerAdjust);
        }
    }

    private static long timeOneHashMap(ReversePurgeLongHashMap hashMap, long[] keys, long[] values, int sizeToShift) {
        long startTime = System.nanoTime();
        int n = keys.length;
        assert (n == values.length);
        for (int i = 0; i < n; ++i) {
            hashMap.adjustOrPutValue(keys[i], values[i]);
            if (hashMap.getNumActive() != sizeToShift) continue;
            hashMap.adjustAllValuesBy(-1L);
            hashMap.keepOnlyPositiveCounts();
        }
        long endTime = System.nanoTime();
        return (endTime - startTime) / (long)n;
    }

    private static long murmur(long key) {
        long[] keyArr = new long[]{key};
        return MurmurHash3.hash((long[])keyArr, (long)0L)[0];
    }

    private static void println(Object obj) {
        System.out.println(obj.toString());
    }

    private static void printf(String fmt, Object ... args) {
        System.out.printf(fmt, args);
    }
}

