/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.creadur.tentacles.FileSystem;
import org.apache.creadur.tentacles.IOSystem;
import org.codehaus.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.codehaus.swizzle.stream.ExcludeFilterInputStream;
import org.codehaus.swizzle.stream.StreamTokenHandler;
import org.codehaus.swizzle.stream.StringTokenHandler;

public class Deauthorize {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("At least one directory must be specified");
        }
        ArrayList<File> dirs = new ArrayList<File>();
        for (String arg : args) {
            File dir = new File(arg);
            if (Deauthorize.not(dir.exists(), "Does not exist: %s", arg)) continue;
            if (Deauthorize.not(dir.isDirectory(), "Not a directory: %s", arg)) continue;
            dirs.add(dir);
        }
        if (dirs.size() != args.length) {
            System.exit(1);
        }
        for (File dir : dirs) {
            Deauthorize.deauthorize(dir);
        }
    }

    private static void deauthorize(File dir) throws IOException {
        Deauthorize.deauthorize(dir, new IOSystem());
    }

    private static void deauthorize(File dir, IOSystem io) throws IOException {
        for (File file : new FileSystem().collect(dir, ".*\\.java")) {
            if (Deauthorize.not(file.canRead(), "File not readable: %s", file.getAbsolutePath())) continue;
            String text = io.slurp(file);
            final String eol = text.contains("\r\n") ? "\r\n" : "\n";
            final String startComment = eol + "/*";
            final String endComment = "*/" + eol;
            ByteArrayInputStream baseIn = new ByteArrayInputStream(text.getBytes());
            ExcludeFilterInputStream in = new ExcludeFilterInputStream((InputStream)baseIn, " * @author", eol);
            byte[] content = io.read((InputStream)(in = new DelimitedTokenReplacementInputStream((InputStream)in, startComment, endComment, (StreamTokenHandler)new StringTokenHandler(){

                public String handleToken(String commentBlock) throws IOException {
                    if (commentBlock.replaceAll("[\\s*]", "").length() == 0) {
                        return eol;
                    }
                    return startComment + commentBlock + endComment;
                }
            })));
            if ((long)content.length == file.length() || Deauthorize.not(file.canWrite(), "File not writable: %s", file.getAbsolutePath())) continue;
            io.copy(content, file);
        }
    }

    private static boolean not(boolean b, String message, Object ... details) {
        boolean bl = b = !b;
        if (b) {
            System.err.printf(message, details);
            System.err.println();
        }
        return b;
    }
}

