/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.SCXMLListener;
import org.apache.commons.scxml.SCXMLSemantics;
import org.apache.commons.scxml.Status;
import org.apache.commons.scxml.Step;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.commons.scxml.semantics.SCXMLSemanticsImpl;

public class SCXMLExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog((Class)SCXMLExecutor.class);
    private SCXML stateMachine;
    private Status currentStatus;
    private EventDispatcher eventdispatcher;
    private ErrorReporter errorReporter = null;
    private boolean superStep = true;
    private SCXMLSemantics semantics;
    private SCInstance scInstance;
    private static final String EVENT_DATA = "_eventdata";
    private static final String EVENT_DATA_MAP = "_eventdatamap";
    private static final String ERR_NO_STATE_MACHINE = "SCXMLExecutor: State machine not set";

    public synchronized void triggerEvents(TriggerEvent[] evts) throws ModelException {
        Object[] oldData = this.setEventData(evts);
        this.semantics.processInvokes(evts, this.errorReporter, this.scInstance);
        ArrayList<TriggerEvent> evs = new ArrayList<TriggerEvent>(Arrays.asList(evts));
        Step step = null;
        do {
            step = new Step(evs, this.currentStatus);
            this.semantics.enumerateReachableTransitions(this.stateMachine, step, this.errorReporter);
            this.semantics.filterTransitionsSet(step, this.eventdispatcher, this.errorReporter, this.scInstance);
            this.semantics.followTransitions(step, this.errorReporter, this.scInstance);
            this.semantics.updateHistoryStates(step, this.errorReporter, this.scInstance);
            this.semantics.executeActions(step, this.stateMachine, this.eventdispatcher, this.errorReporter, this.scInstance);
            this.updateStatus(step);
            if (!this.superStep) continue;
            evs.clear();
        } while (this.superStep && this.currentStatus.getEvents().size() > 0);
        this.semantics.initiateInvokes(step, this.errorReporter, this.scInstance);
        this.restoreEventData(oldData);
        this.logState();
    }

    public void triggerEvent(TriggerEvent evt) throws ModelException {
        this.triggerEvents(new TriggerEvent[]{evt});
    }

    public SCXMLExecutor(Evaluator expEvaluator, EventDispatcher evtDisp, ErrorReporter errRep) {
        this(expEvaluator, evtDisp, errRep, null);
    }

    public SCXMLExecutor() {
        this(null, null, null, null);
    }

    public SCXMLExecutor(Evaluator expEvaluator, EventDispatcher evtDisp, ErrorReporter errRep, SCXMLSemantics semantics) {
        this.eventdispatcher = evtDisp;
        this.errorReporter = errRep;
        this.currentStatus = new Status();
        this.stateMachine = null;
        this.semantics = semantics == null ? new SCXMLSemanticsImpl() : semantics;
        this.scInstance = new SCInstance(this);
        this.scInstance.setEvaluator(expEvaluator);
    }

    public synchronized void reset() throws ModelException {
        Context rootCtx = this.scInstance.getRootContext();
        if (this.stateMachine == null) {
            this.log.error((Object)ERR_NO_STATE_MACHINE);
            throw new ModelException(ERR_NO_STATE_MACHINE);
        }
        Datamodel rootdm = this.stateMachine.getDatamodel();
        SCXMLHelper.cloneDatamodel(rootdm, rootCtx, this.scInstance.getEvaluator(), this.log);
        Iterator i = this.stateMachine.getTargets().values().iterator();
        while (i.hasNext()) {
            TransitionTarget tt = (TransitionTarget)i.next();
            if (tt instanceof State) {
                Context context = this.scInstance.lookupContext(tt);
                if (context == null) continue;
                context.reset();
                Datamodel dm = tt.getDatamodel();
                if (dm == null) continue;
                SCXMLHelper.cloneDatamodel(dm, context, this.scInstance.getEvaluator(), this.log);
                continue;
            }
            if (!(tt instanceof History)) continue;
            this.scInstance.reset((History)tt);
        }
        this.currentStatus = new Status();
        Step step = new Step(null, this.currentStatus);
        this.semantics.determineInitialStates(this.stateMachine, step.getAfterStatus().getStates(), step.getEntryList(), this.errorReporter, this.scInstance);
        this.semantics.executeActions(step, this.stateMachine, this.eventdispatcher, this.errorReporter, this.scInstance);
        this.updateStatus(step);
        if (this.superStep && this.currentStatus.getEvents().size() > 0) {
            this.triggerEvents(new TriggerEvent[0]);
        } else {
            this.semantics.initiateInvokes(step, this.errorReporter, this.scInstance);
            this.logState();
        }
    }

    public synchronized Status getCurrentStatus() {
        return this.currentStatus;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.scInstance.setEvaluator(evaluator);
    }

    public Evaluator getEvaluator() {
        return this.scInstance.getEvaluator();
    }

    public void setRootContext(Context rootContext) {
        this.scInstance.setRootContext(rootContext);
    }

    public Context getRootContext() {
        return this.scInstance.getRootContext();
    }

    public SCXML getStateMachine() {
        return this.stateMachine;
    }

    public void setStateMachine(SCXML stateMachine) {
        SCXML sm;
        this.stateMachine = sm = this.semantics.normalizeStateMachine(stateMachine, this.errorReporter);
    }

    public void go() throws ModelException {
        this.reset();
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public EventDispatcher getEventdispatcher() {
        return this.eventdispatcher;
    }

    public void setEventdispatcher(EventDispatcher eventdispatcher) {
        this.eventdispatcher = eventdispatcher;
    }

    public boolean isSuperStep() {
        return this.superStep;
    }

    public void setSuperStep(boolean superStep) {
        this.superStep = superStep;
    }

    public void addListener(SCXML scxml, SCXMLListener listener) {
        SCXML observable = scxml;
        this.scInstance.getNotificationRegistry().addListener(observable, listener);
    }

    public void removeListener(SCXML scxml, SCXMLListener listener) {
        SCXML observable = scxml;
        this.scInstance.getNotificationRegistry().removeListener(observable, listener);
    }

    public void addListener(TransitionTarget transitionTarget, SCXMLListener listener) {
        TransitionTarget observable = transitionTarget;
        this.scInstance.getNotificationRegistry().addListener(observable, listener);
    }

    public void removeListener(TransitionTarget transitionTarget, SCXMLListener listener) {
        TransitionTarget observable = transitionTarget;
        this.scInstance.getNotificationRegistry().removeListener(observable, listener);
    }

    public void addListener(Transition transition, SCXMLListener listener) {
        Transition observable = transition;
        this.scInstance.getNotificationRegistry().addListener(observable, listener);
    }

    public void removeListener(Transition transition, SCXMLListener listener) {
        Transition observable = transition;
        this.scInstance.getNotificationRegistry().removeListener(observable, listener);
    }

    public void registerInvokerClass(String targettype, Class invokerClass) {
        this.scInstance.registerInvokerClass(targettype, invokerClass);
    }

    public void unregisterInvokerClass(String targettype) {
        this.scInstance.unregisterInvokerClass(targettype);
    }

    SCInstance getSCInstance() {
        return this.scInstance;
    }

    private void logState() {
        if (this.log.isDebugEnabled()) {
            Iterator si = this.currentStatus.getStates().iterator();
            StringBuffer sb = new StringBuffer("Current States: [");
            while (si.hasNext()) {
                State s = (State)si.next();
                sb.append(s.getId());
                if (!si.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(']');
            this.log.debug((Object)sb.toString());
        }
    }

    private void updateStatus(Step step) {
        this.currentStatus = step.getAfterStatus();
        this.scInstance.getRootContext().setLocal("_ALL_STATES", SCXMLHelper.getAncestorClosure(this.currentStatus.getStates(), null));
        this.setEventData(this.currentStatus.getEvents().toArray(new TriggerEvent[0]));
    }

    private Object[] setEventData(TriggerEvent[] evts) {
        Context rootCtx = this.scInstance.getRootContext();
        Object[] oldData = new Object[]{rootCtx.get(EVENT_DATA), rootCtx.get(EVENT_DATA_MAP)};
        int len = evts.length;
        if (len > 0) {
            Object eventData = null;
            HashMap<String, Object> payloadMap = new HashMap<String, Object>();
            for (int i = 0; i < len; ++i) {
                TriggerEvent te = evts[i];
                payloadMap.put(te.getName(), te.getPayload());
            }
            if (len == 1) {
                eventData = evts[0].getPayload();
            }
            rootCtx.setLocal(EVENT_DATA, eventData);
            rootCtx.setLocal(EVENT_DATA_MAP, payloadMap);
        }
        return oldData;
    }

    private void restoreEventData(Object[] oldData) {
        this.scInstance.getRootContext().setLocal(EVENT_DATA, oldData[0]);
        this.scInstance.getRootContext().setLocal(EVENT_DATA_MAP, oldData[1]);
    }
}

