/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import java.util.ArrayList;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunction;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunctionJacobian;

@Deprecated
class CircleVectorial {
    private ArrayList<Vector2D> points = new ArrayList();

    public void addPoint(double px, double py) {
        this.points.add(new Vector2D(px, py));
    }

    public int getN() {
        return this.points.size();
    }

    public double getRadius(Vector2D center) {
        double r = 0.0;
        for (Vector2D point : this.points) {
            r += point.distance((Vector)center);
        }
        return r / (double)this.points.size();
    }

    public ModelFunction getModelFunction() {
        return new ModelFunction(new MultivariateVectorFunction(){

            public double[] value(double[] params) {
                Vector2D center = new Vector2D(params[0], params[1]);
                double radius = CircleVectorial.this.getRadius(center);
                double[] residuals = new double[CircleVectorial.this.points.size()];
                for (int i = 0; i < residuals.length; ++i) {
                    residuals[i] = ((Vector2D)CircleVectorial.this.points.get(i)).distance((Vector)center) - radius;
                }
                return residuals;
            }
        });
    }

    public ModelFunctionJacobian getModelFunctionJacobian() {
        return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

            public double[][] value(double[] params) {
                int n = CircleVectorial.this.points.size();
                Vector2D center = new Vector2D(params[0], params[1]);
                double dRdX = 0.0;
                double dRdY = 0.0;
                for (Vector2D pk : CircleVectorial.this.points) {
                    double dk = pk.distance((Vector)center);
                    dRdX += (center.getX() - pk.getX()) / dk;
                    dRdY += (center.getY() - pk.getY()) / dk;
                }
                dRdX /= (double)n;
                dRdY /= (double)n;
                double[][] jacobian = new double[n][2];
                for (int i = 0; i < n; ++i) {
                    Vector2D pi = (Vector2D)CircleVectorial.this.points.get(i);
                    double di = pi.distance((Vector)center);
                    jacobian[i][0] = (center.getX() - pi.getX()) / di - dRdX;
                    jacobian[i][1] = (center.getY() - pi.getY()) / di - dRdY;
                }
                return jacobian;
            }
        });
    }
}

