/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.IndegreeTopologicalSort;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.layout.Layer;
import org.objectstyle.ashwood.graph.layout.LayerVertex;
import org.objectstyle.ashwood.graph.layout.NestedSubgraph;
import org.objectstyle.ashwood.graph.layout.NestingTreeNode;
import org.objectstyle.ashwood.util.IndexComparator;

public class SubgraphPartition {
    private NestedSubgraph root;

    public void setPartition(NestedSubgraph root) {
        this.root = root;
    }

    public void groupVertices(Layer layer) {
        this.root.computePosition(layer.getRank());
        this.root.reindex(layer.getRank(), 0);
        layer.sort();
    }

    public void untwineSubgraphs(Layer[] layers) {
        this.root.computePosition();
        MapDigraph subgraphOrderingGraph = new MapDigraph();
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].size() - 1; ++j) {
                LayerVertex v1 = layers[i].getVertex(j);
                LayerVertex v2 = layers[i].getVertex(j + 1);
                subgraphOrderingGraph.putArc(v1, v2, Boolean.TRUE);
                NestingTreeNode origin = v1.getParentSubgraph();
                NestingTreeNode dst = v2.getParentSubgraph();
                subgraphOrderingGraph.addVertex(origin);
                subgraphOrderingGraph.addVertex(dst);
                if (origin == dst) continue;
                if (origin == this.root) {
                    origin = v1;
                }
                if (dst == this.root) {
                    dst = v2;
                }
                subgraphOrderingGraph.putArc(origin, dst, Boolean.TRUE);
            }
        }
        List cycles = GraphUtils.findCycles(subgraphOrderingGraph);
        for (ArrayList cycle : cycles) {
            int minWeightIndex = -1;
            double minWeight = Double.POSITIVE_INFINITY;
            for (int j = 0; j < cycle.size(); ++j) {
                double weight = ((NestingTreeNode)cycle.get(j)).getPosition();
                if (!(weight < minWeight)) continue;
                minWeightIndex = j;
                minWeight = weight;
            }
            if (minWeightIndex > 0) {
                subgraphOrderingGraph.removeArc(cycle.get(minWeightIndex - 1), cycle.get(minWeightIndex));
                continue;
            }
            subgraphOrderingGraph.removeArc(cycle.get(cycle.size() - 1), cycle.get(0));
        }
        IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(subgraphOrderingGraph);
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        int sortIndex = 0;
        while (sorter.hasNext()) {
            indexMap.put(sorter.next(), new Integer(sortIndex++));
        }
        IndexComparator comparator = new IndexComparator(indexMap);
        for (int i = 0; i < layers.length; ++i) {
            this.root.reindex(i, 0, comparator, new NestedSubgraph.PositionPredicate(i));
            layers[i].sort();
        }
    }

    public void insertBorderSegments(Layer[] layers) {
        int i;
        List children = this.root.getChildren();
        for (i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            if (!(child instanceof NestedSubgraph)) continue;
            ((NestedSubgraph)child).createBorders();
        }
        for (i = 0; i < layers.length; ++i) {
            Layer layer = layers[i];
            int size = layer.size();
            for (int j = 0; j < size; ++j) {
                LayerVertex border;
                LayerVertex v = layer.getVertex(j);
                NestedSubgraph subgraph = v.getParentSubgraph();
                if (subgraph == this.root) continue;
                LayerVertex leftNeighbor = layer.getLeft(v);
                LayerVertex rightNeighbor = layer.getRight(v);
                NestedSubgraph leftNeighborSubgraph = leftNeighbor != null ? leftNeighbor.getParentSubgraph() : null;
                NestedSubgraph rightNeighborSubgraph = rightNeighbor != null ? rightNeighbor.getParentSubgraph() : null;
                boolean borderAdded = false;
                if (subgraph != leftNeighborSubgraph) {
                    border = subgraph.getLeftBorderVertex(i);
                    layer.add(j, border);
                    ++j;
                    ++size;
                    borderAdded = true;
                }
                if (subgraph != rightNeighborSubgraph) {
                    border = subgraph.getRightBorderVertex(i);
                    ++size;
                    layer.add(++j, border);
                    borderAdded = true;
                }
                if (!borderAdded) continue;
                layer.refreshIndices();
            }
            layer.refreshIndices();
        }
    }
}

