/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.util;

import java.awt.Image;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceLoader {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$util$ResourceLoader == null ? (class$org$scopemvc$util$ResourceLoader = ResourceLoader.class$("org.scopemvc.util.ResourceLoader")) : class$org$scopemvc$util$ResourceLoader);
    private static ClassLoader clientClassLoader;
    private static ClassLoader scopeClassLoader;
    static /* synthetic */ Class class$org$scopemvc$util$ResourceLoader;

    private ResourceLoader() {
    }

    public static ClassLoader getClientLoader() {
        return clientClassLoader;
    }

    public static Icon getIcon(String string) {
        URL uRL = ResourceLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    public static Image getImage(String string) {
        URL uRL = ResourceLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL).getImage();
    }

    public static URL getResource(String string) {
        URL uRL = null;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (ResourceLoader.getClientLoader() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading " + string2 + " using client classloader " + ResourceLoader.getClientLoader());
            }
            uRL = ResourceLoader.getClientLoader().getResource(string2);
        }
        if (uRL == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading " + string2 + " using scope classloader " + scopeClassLoader);
            }
            uRL = scopeClassLoader.getResource(string2);
        }
        if (uRL == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading " + string2 + " using system classloader " + ClassLoader.getSystemClassLoader());
            }
            uRL = ClassLoader.getSystemClassLoader().getResource(string2);
        }
        return uRL;
    }

    public static ResourceBundle getProperties(String string) {
        ResourceBundle resourceBundle = null;
        if (string != null) {
            block4: {
                try {
                    resourceBundle = clientClassLoader != null ? ResourceBundle.getBundle(string, Locale.getDefault(), clientClassLoader) : ResourceBundle.getBundle(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Can't load config: " + string, missingResourceException);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getProperties: " + resourceBundle);
            }
        }
        return resourceBundle;
    }

    public static ClassLoader getClientClassLoader() {
        return clientClassLoader;
    }

    public static void setClientClassLoader(ClassLoader classLoader) {
        clientClassLoader = classLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        scopeClassLoader = (class$org$scopemvc$util$ResourceLoader == null ? (class$org$scopemvc$util$ResourceLoader = ResourceLoader.class$("org.scopemvc.util.ResourceLoader")) : class$org$scopemvc$util$ResourceLoader).getClassLoader();
    }
}

