/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.derby;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.derby.DerbyMergerFactory;
import org.apache.cayenne.dba.derby.DerbyPkGenerator;
import org.apache.cayenne.dba.derby.DerbyQualifierTranslator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.MergerFactory;

public class DerbyAdapter
extends JdbcAdapter {
    static final String FOR_BIT_DATA_SUFFIX = " FOR BIT DATA";

    public DerbyAdapter() {
        this.setSupportsGeneratedKeys(true);
        this.setSupportsBatchUpdates(true);
    }

    protected PkGenerator createPkGenerator() {
        return new DerbyPkGenerator();
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
    }

    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        boolean status = column.getEntity().getDataMap() != null && column.getEntity().getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy context = this.getQuotingStrategy(status);
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? ((DbEntity)column.getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + column.getName() + "': " + column.getType());
        }
        String type = types[0];
        String length = "";
        if (this.typeSupportsLength(column.getType())) {
            int scale;
            int len = column.getMaxLength();
            int n = scale = TypesMapping.isDecimal(column.getType()) ? column.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                length = " (" + len;
                if (scale >= 0) {
                    length = length + ", " + scale;
                }
                length = length + ")";
            }
        }
        sqlBuffer.append(context.quoteString(column.getName()));
        sqlBuffer.append(' ');
        if (length.length() > 0 && type.endsWith(FOR_BIT_DATA_SUFFIX)) {
            sqlBuffer.append(type.substring(0, type.length() - FOR_BIT_DATA_SUFFIX.length()));
            sqlBuffer.append(length);
            sqlBuffer.append(FOR_BIT_DATA_SUFFIX);
        } else {
            sqlBuffer.append(type).append(length);
        }
        if (column.isMandatory()) {
            sqlBuffer.append(" NOT NULL");
        }
        if (column.isGenerated()) {
            sqlBuffer.append(" GENERATED BY DEFAULT AS IDENTITY");
        }
    }

    private boolean typeSupportsLength(int type) {
        switch (type) {
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return TypesMapping.supportsLength(type);
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new DerbyQualifierTranslator(queryAssembler, "RTRIM");
    }

    public MergerFactory mergerFactory() {
        return new DerbyMergerFactory();
    }

    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int precision) throws SQLException, Exception {
        if (object == null && sqlType == 0) {
            statement.setNull(pos, 12);
        } else {
            super.bindParameter(statement, object, pos, sqlType, precision);
        }
    }
}

