/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.PropertyChangeProcessingStrategy;
import org.apache.cayenne.graph.ChildDiffLoader;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class CayenneContextChildDiffLoader
extends ChildDiffLoader {
    public CayenneContextChildDiffLoader(CayenneContext context) {
        super(context);
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        super.nodePropertyChanged(nodeId, property, oldValue, newValue);
        Persistent object = (Persistent)this.context.getGraphManager().getNode(nodeId);
        this.context.propertyChanged(object, property, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        final Persistent source = this.findObject(nodeId);
        final Persistent target = this.findObject(targetNodeId);
        if (target == null) {
            return;
        }
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        ArcProperty property = (ArcProperty)descriptor.getProperty(arcId.toString());
        PropertyChangeProcessingStrategy oldStrategy = ((CayenneContext)this.context).getPropertyChangeProcessingStrategy();
        ((CayenneContext)this.context).setPropertyChangeProcessingStrategy(PropertyChangeProcessingStrategy.IGNORE);
        try {
            property.visit(new PropertyVisitor(){

                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }

                public boolean visitToMany(ToManyProperty property) {
                    ArcProperty reverseArc = property.getComplimentaryReverseArc();
                    boolean autoConnectReverse = reverseArc != null && reverseArc.getRelationship().isRuntime();
                    property.addTarget(source, target, autoConnectReverse);
                    return false;
                }

                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(source, target, false);
                    return false;
                }
            });
        }
        finally {
            ((CayenneContext)this.context).setPropertyChangeProcessingStrategy(oldStrategy);
        }
        this.context.propertyChanged(source, (String)arcId, null, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arcDeleted(Object nodeId, final Object targetNodeId, Object arcId) {
        final Persistent source = this.findObject(nodeId);
        if (source == null) {
            return;
        }
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        Property property = descriptor.getProperty(arcId.toString());
        PropertyChangeProcessingStrategy oldStrategy = ((CayenneContext)this.context).getPropertyChangeProcessingStrategy();
        ((CayenneContext)this.context).setPropertyChangeProcessingStrategy(PropertyChangeProcessingStrategy.IGNORE);
        final Persistent[] target = new Persistent[]{this.findObject(targetNodeId)};
        try {
            property.visit(new PropertyVisitor(){

                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }

                public boolean visitToMany(ToManyProperty property) {
                    boolean autoConnectReverse;
                    ArcProperty reverseArc = property.getComplimentaryReverseArc();
                    boolean bl = autoConnectReverse = reverseArc != null && reverseArc.getRelationship().isRuntime();
                    if (target[0] == null) {
                        target[0] = CayenneContextChildDiffLoader.this.findObjectInCollection(targetNodeId, property.readProperty(source));
                    }
                    if (target[0] != null) {
                        property.removeTarget(source, target[0], autoConnectReverse);
                    }
                    return false;
                }

                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(source, null, false);
                    return false;
                }
            });
        }
        finally {
            ((CayenneContext)this.context).setPropertyChangeProcessingStrategy(oldStrategy);
        }
        this.context.propertyChanged(source, (String)arcId, target[0], null);
    }
}

