/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Integrate with Consul service discovery and configuration store.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ConsulEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Consul component.
     */
    public interface ConsulEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedConsulEndpointConsumerBuilder advanced() {
            return (AdvancedConsulEndpointConsumerBuilder) this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder connectTimeout(java.time.Duration connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder connectTimeout(String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Reference to a org.kiwiproject.consul.Consul in the registry.
         * 
         * The option is a: <code>org.kiwiproject.consul.Consul</code> type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder consulClient(org.kiwiproject.consul.Consul consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * Reference to a org.kiwiproject.consul.Consul in the registry.
         * 
         * The option will be converted to a
         * <code>org.kiwiproject.consul.Consul</code> type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder consulClient(String consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * The default key. Can be overridden by CamelConsulKey.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder pingInstance(boolean pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder pingInstance(String pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder readTimeout(java.time.Duration readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * The Consul agent URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder writeTimeout(java.time.Duration writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Sets the ACL token to be used with Consul.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param aclToken the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder aclToken(String aclToken) {
            doSetProperty("aclToken", aclToken);
            return this;
        }
        /**
         * Sets the password to be used for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the username to be used for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * The second to wait for a watch event, default 10 seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10
         * Group: watch
         * 
         * @param blockSeconds the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder blockSeconds(Integer blockSeconds) {
            doSetProperty("blockSeconds", blockSeconds);
            return this;
        }
        /**
         * The second to wait for a watch event, default 10 seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10
         * Group: watch
         * 
         * @param blockSeconds the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder blockSeconds(String blockSeconds) {
            doSetProperty("blockSeconds", blockSeconds);
            return this;
        }
        /**
         * The first index for watch for, default 0.
         * 
         * The option is a: <code>java.math.BigInteger</code> type.
         * 
         * Default: 0
         * Group: watch
         * 
         * @param firstIndex the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder firstIndex(java.math.BigInteger firstIndex) {
            doSetProperty("firstIndex", firstIndex);
            return this;
        }
        /**
         * The first index for watch for, default 0.
         * 
         * The option will be converted to a <code>java.math.BigInteger</code>
         * type.
         * 
         * Default: 0
         * Group: watch
         * 
         * @param firstIndex the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder firstIndex(String firstIndex) {
            doSetProperty("firstIndex", firstIndex);
            return this;
        }
        /**
         * Recursively watch, default false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: watch
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder recursive(boolean recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * Recursively watch, default false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: watch
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder recursive(String recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Consul component.
     */
    public interface AdvancedConsulEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ConsulEndpointConsumerBuilder basic() {
            return (ConsulEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option is a:
         * <code>org.kiwiproject.consul.option.ConsistencyMode</code> type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder consistencyMode(org.kiwiproject.consul.option.ConsistencyMode consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option will be converted to a
         * <code>org.kiwiproject.consul.option.ConsistencyMode</code> type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder consistencyMode(String consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The data center.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param datacenter the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder datacenter(String datacenter) {
            doSetProperty("datacenter", datacenter);
            return this;
        }
        /**
         * The near node to use for queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param nearNode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder nearNode(String nearNode) {
            doSetProperty("nearNode", nearNode);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder nodeMeta(List<java.lang.String> nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder nodeMeta(String nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Consul component.
     */
    public interface ConsulEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedConsulEndpointProducerBuilder advanced() {
            return (AdvancedConsulEndpointProducerBuilder) this;
        }

        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder connectTimeout(java.time.Duration connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder connectTimeout(String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Reference to a org.kiwiproject.consul.Consul in the registry.
         * 
         * The option is a: <code>org.kiwiproject.consul.Consul</code> type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder consulClient(org.kiwiproject.consul.Consul consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * Reference to a org.kiwiproject.consul.Consul in the registry.
         * 
         * The option will be converted to a
         * <code>org.kiwiproject.consul.Consul</code> type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder consulClient(String consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * The default key. Can be overridden by CamelConsulKey.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder pingInstance(boolean pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder pingInstance(String pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder readTimeout(java.time.Duration readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * The Consul agent URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder writeTimeout(java.time.Duration writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * The default action. Can be overridden by CamelConsulAction.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param action the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder action(String action) {
            doSetProperty("action", action);
            return this;
        }
        /**
         * Default to transform values retrieved from Consul i.e. on KV endpoint
         * to string.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param valueAsString the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder valueAsString(boolean valueAsString) {
            doSetProperty("valueAsString", valueAsString);
            return this;
        }
        /**
         * Default to transform values retrieved from Consul i.e. on KV endpoint
         * to string.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param valueAsString the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder valueAsString(String valueAsString) {
            doSetProperty("valueAsString", valueAsString);
            return this;
        }
        /**
         * Sets the ACL token to be used with Consul.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param aclToken the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder aclToken(String aclToken) {
            doSetProperty("aclToken", aclToken);
            return this;
        }
        /**
         * Sets the password to be used for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the username to be used for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Consul component.
     */
    public interface AdvancedConsulEndpointProducerBuilder extends EndpointProducerBuilder {
        default ConsulEndpointProducerBuilder basic() {
            return (ConsulEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option is a:
         * <code>org.kiwiproject.consul.option.ConsistencyMode</code> type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder consistencyMode(org.kiwiproject.consul.option.ConsistencyMode consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option will be converted to a
         * <code>org.kiwiproject.consul.option.ConsistencyMode</code> type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder consistencyMode(String consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The data center.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param datacenter the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder datacenter(String datacenter) {
            doSetProperty("datacenter", datacenter);
            return this;
        }
        /**
         * The near node to use for queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param nearNode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder nearNode(String nearNode) {
            doSetProperty("nearNode", nearNode);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder nodeMeta(List<java.lang.String> nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder nodeMeta(String nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Consul component.
     */
    public interface ConsulEndpointBuilder
            extends
                ConsulEndpointConsumerBuilder,
                ConsulEndpointProducerBuilder {
        default AdvancedConsulEndpointBuilder advanced() {
            return (AdvancedConsulEndpointBuilder) this;
        }

        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder connectTimeout(java.time.Duration connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder connectTimeout(String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Reference to a org.kiwiproject.consul.Consul in the registry.
         * 
         * The option is a: <code>org.kiwiproject.consul.Consul</code> type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consulClient(org.kiwiproject.consul.Consul consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * Reference to a org.kiwiproject.consul.Consul in the registry.
         * 
         * The option will be converted to a
         * <code>org.kiwiproject.consul.Consul</code> type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consulClient(String consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * The default key. Can be overridden by CamelConsulKey.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder pingInstance(boolean pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder pingInstance(String pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder readTimeout(java.time.Duration readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * The Consul agent URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder writeTimeout(java.time.Duration writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Sets the ACL token to be used with Consul.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param aclToken the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder aclToken(String aclToken) {
            doSetProperty("aclToken", aclToken);
            return this;
        }
        /**
         * Sets the password to be used for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the username to be used for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Consul component.
     */
    public interface AdvancedConsulEndpointBuilder
            extends
                AdvancedConsulEndpointConsumerBuilder,
                AdvancedConsulEndpointProducerBuilder {
        default ConsulEndpointBuilder basic() {
            return (ConsulEndpointBuilder) this;
        }

        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option is a:
         * <code>org.kiwiproject.consul.option.ConsistencyMode</code> type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder consistencyMode(org.kiwiproject.consul.option.ConsistencyMode consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option will be converted to a
         * <code>org.kiwiproject.consul.option.ConsistencyMode</code> type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder consistencyMode(String consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The data center.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param datacenter the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder datacenter(String datacenter) {
            doSetProperty("datacenter", datacenter);
            return this;
        }
        /**
         * The near node to use for queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param nearNode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder nearNode(String nearNode) {
            doSetProperty("nearNode", nearNode);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder nodeMeta(List<java.lang.String> nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder nodeMeta(String nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
    }

    public interface ConsulBuilders {
        /**
         * Consul (camel-consul)
         * Integrate with Consul service discovery and configuration store.
         * 
         * Category: cloud,api
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-consul
         * 
         * @return the dsl builder for the headers' name.
         */
        default ConsulHeaderNameBuilder consul() {
            return ConsulHeaderNameBuilder.INSTANCE;
        }
        /**
         * Consul (camel-consul)
         * Integrate with Consul service discovery and configuration store.
         * 
         * Category: cloud,api
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-consul
         * 
         * Syntax: <code>consul:apiEndpoint</code>
         * 
         * Path parameter: apiEndpoint (required)
         * The API endpoint
         * 
         * @param path apiEndpoint
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consul(String path) {
            return ConsulEndpointBuilderFactory.endpointBuilder("consul", path);
        }
        /**
         * Consul (camel-consul)
         * Integrate with Consul service discovery and configuration store.
         * 
         * Category: cloud,api
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-consul
         * 
         * Syntax: <code>consul:apiEndpoint</code>
         * 
         * Path parameter: apiEndpoint (required)
         * The API endpoint
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiEndpoint
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consul(String componentName, String path) {
            return ConsulEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Consul component.
     */
    public static class ConsulHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final ConsulHeaderNameBuilder INSTANCE = new ConsulHeaderNameBuilder();

        /**
         * The Producer action.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulAction}.
         */
        public String consulAction() {
            return "CamelConsulAction";
        }
        /**
         * The Key on which the action should applied.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code ConsulKey}.
         */
        public String consulKey() {
            return "CamelConsulKey";
        }
        /**
         * The event id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulEventId}.
         */
        public String consulEventId() {
            return "CamelConsulEventId";
        }
        /**
         * The event name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulEventName}.
         */
        public String consulEventName() {
            return "CamelConsulEventName";
        }
        /**
         * The event LTime.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulEventLTime}.
         */
        public String consulEventLTime() {
            return "CamelConsulEventLTime";
        }
        /**
         * The Node filter.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulNodeFilter}.
         */
        public String consulNodeFilter() {
            return "CamelConsulNodeFilter";
        }
        /**
         * The tag filter.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulTagFilter}.
         */
        public String consulTagFilter() {
            return "CamelConsulTagFilter";
        }
        /**
         * The session filter.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulSessionFilter}.
         */
        public String consulSessionFilter() {
            return "CamelConsulSessionFilter";
        }
        /**
         * The data version.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulVersion}.
         */
        public String consulVersion() {
            return "CamelConsulVersion";
        }
        /**
         * Flags associated with a value.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code ConsulFlags}.
         */
        public String consulFlags() {
            return "CamelConsulFlags";
        }
        /**
         * The optional value index.
         * 
         * The option is a: {@code BigInteger} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulIndex}.
         */
        public String consulIndex() {
            return "CamelConsulIndex";
        }
        /**
         * The optional value wait.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulWait}.
         */
        public String consulWait() {
            return "CamelConsulWait";
        }
        /**
         * The internal index value that represents when the entry was created.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulCreateIndex}.
         */
        public String consulCreateIndex() {
            return "CamelConsulCreateIndex";
        }
        /**
         * The number of times this key has successfully been acquired in a
         * lock.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulLockIndex}.
         */
        public String consulLockIndex() {
            return "CamelConsulLockIndex";
        }
        /**
         * The last index that modified this key.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ConsulModifyIndex}.
         */
        public String consulModifyIndex() {
            return "CamelConsulModifyIndex";
        }
        /**
         * Options associated to the request.
         * 
         * The option is a: {@code } type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code ConsulOptions}.
         */
        public String consulOptions() {
            return "CamelConsulOptions";
        }
        /**
         * true if the response has a result.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code ConsulResult}.
         */
        public String consulResult() {
            return "CamelConsulResult";
        }
        /**
         * The session id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code ConsulSession}.
         */
        public String consulSession() {
            return "CamelConsulSession";
        }
        /**
         * To transform values retrieved from Consul i.e. on KV endpoint to
         * string.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulValueAsString}.
         */
        public String consulValueAsString() {
            return "CamelConsulValueAsString";
        }
        /**
         * The node.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulNode}.
         */
        public String consulNode() {
            return "CamelConsulNode";
        }
        /**
         * The service.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulService}.
         */
        public String consulService() {
            return "CamelConsulService";
        }
        /**
         * The data center.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulDatacenter}.
         */
        public String consulDatacenter() {
            return "CamelConsulDatacenter";
        }
        /**
         * The near node to use for queries.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulNearNode}.
         */
        public String consulNearNode() {
            return "CamelConsulNearNode";
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulNodeMeta}.
         */
        public String consulNodeMeta() {
            return "CamelConsulNodeMeta";
        }
        /**
         * The last contact.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulLastContact}.
         */
        public String consulLastContact() {
            return "CamelConsulLastContact";
        }
        /**
         * Indicates whether it is the known leader.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulKnownLeader}.
         */
        public String consulKnownLeader() {
            return "CamelConsulKnownLeader";
        }
        /**
         * The consistencyMode used for queries.
         * 
         * The option is a: {@code
         * org.kiwiproject.consul.option.ConsistencyMode} type.
         * 
         * Default: DEFAULT
         * Group: producer
         * 
         * @return the name of the header {@code ConsulConsistencyMode}.
         */
        public String consulConsistencyMode() {
            return "CamelConsulConsistencyMode";
        }
        /**
         * Only on healthy services.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Default: false
         * Group: producer
         * 
         * @return the name of the header {@code ConsulHealthyOnly}.
         */
        public String consulHealthyOnly() {
            return "CamelConsulHealthyOnly";
        }
        /**
         * The state to query.
         * 
         * The option is a: {@code org.kiwiproject.consul.model.State} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulHealthyState}.
         */
        public String consulHealthyState() {
            return "CamelConsulHealthyState";
        }
        /**
         * The id of the prepared query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulPreparedQueryID}.
         */
        public String consulPreparedQueryID() {
            return "CamelConsulPreparedQueryID";
        }
        /**
         * The service id for agent deregistration.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ConsulServiceId}.
         */
        public String consulServiceId() {
            return "CamelConsulServiceId";
        }
    }
    static ConsulEndpointBuilder endpointBuilder(String componentName, String path) {
        class ConsulEndpointBuilderImpl extends AbstractEndpointBuilder implements ConsulEndpointBuilder, AdvancedConsulEndpointBuilder {
            public ConsulEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ConsulEndpointBuilderImpl(path);
    }
}