/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.util.function;

import java.util.function.Supplier;

/**
 * Represents a supplier of results that may thrown an exception.
 *
 * @param <T> the type of the exception the accept method may throw.
 *
 * @see       Supplier
 */
@FunctionalInterface
public interface ThrowingSupplier<V, T extends Throwable> {
    /**
     * Get a result, potentially throwing an exception.
     *
     * @return   the result
     * @throws T the exception that may be thrown
     */
    V get() throws T;
}
