/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.extensions.soap.SOAPModuleElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.WSDLElement;

public class SOAPModuleDeserializer
implements ExtensionDeserializer {
    public ExtensionElement unmarshall(Class parentType, Object parent, QName elementType, XMLElement el, DescriptionElement desc, ExtensionRegistry extReg) throws WSDLException {
        SOAPModuleElement soapMod = (SOAPModuleElement)extReg.createExtElement(parentType, elementType);
        soapMod.setExtensionType(elementType);
        soapMod.setParentElement((WSDLElement)parent);
        String ref = el.getAttributeValue("ref");
        if (ref != null) {
            try {
                URI uri = new URI(ref);
                soapMod.setRef(uri);
            }
            catch (URISyntaxException e) {
                extReg.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{ref}, (short)2, (Exception)e);
            }
        }
        String required = el.getAttributeValue("required");
        soapMod.setRequired(new Boolean(required));
        for (XMLElement tempEl = el.getFirstChildElement(); tempEl != null; tempEl = tempEl.getNextSiblingElement()) {
            if (!Constants.Q_ELEM_DOCUMENTATION.equals(tempEl.getQName())) continue;
            soapMod.addDocumentationElement(this.parseDocumentation(tempEl, desc));
        }
        return soapMod;
    }

    private DocumentationElement parseDocumentation(XMLElement docEl, DocumentableElement parent) throws WSDLException {
        DocumentationElement documentation = parent.addDocumentationElement();
        documentation.setContent(docEl);
        return documentation;
    }
}

