/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrderedMap
extends AbstractMap {
    private Set _entrySet = new OrderedSet();

    public Set entrySet() {
        return this._entrySet;
    }

    public Object put(Object key, Object value) {
        Entry existingEntry = this.getEntryWithKey(key);
        if (existingEntry == null) {
            this.entrySet().add(new Entry(key, value));
            return null;
        }
        Object previousValue = existingEntry.getValue();
        existingEntry.setValue(value);
        return previousValue;
    }

    private Entry getEntryWithKey(Object key) {
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            if (!OrderedMap.eq(e.getKey(), key)) continue;
            return e;
        }
        return null;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static class Entry
    implements Map.Entry {
        Object _key;
        Object _value;

        public Entry(Object key, Object value) {
            this._key = key;
            this._value = value;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return OrderedMap.eq(this._key, e.getKey()) && OrderedMap.eq(this._value, e.getValue());
        }

        public int hashCode() {
            return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    static class OrderedSet
    extends AbstractSet {
        private List _elementList = new LinkedList();

        OrderedSet() {
        }

        public int size() {
            return this._elementList.size();
        }

        public Iterator iterator() {
            return this._elementList.iterator();
        }

        public boolean add(Object o) {
            this._elementList.add(o);
            return true;
        }
    }
}

