/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io.profiling;

import org.apache.hyracks.control.nc.io.profiling.IIOCounter;
import org.apache.hyracks.control.nc.io.profiling.IOCounterDefault;
import org.apache.hyracks.control.nc.io.profiling.IOCounterIoStat;
import org.apache.hyracks.control.nc.io.profiling.IOCounterOSX;
import org.apache.hyracks.control.nc.io.profiling.IOCounterProc;

public class IOCounterFactory {
    public static final IOCounterFactory INSTANCE = new IOCounterFactory();

    private IOCounterFactory() {
    }

    public IIOCounter getIOCounter() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            if (IOCounterProc.STATFILE.exists()) {
                return new IOCounterProc();
            }
            return new IOCounterIoStat();
        }
        if (osName.contains("mac")) {
            return new IOCounterOSX();
        }
        return new IOCounterDefault();
    }
}

