/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.shiro.authc.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Feature;
import org.apache.aries.jax.rs.shiro.authc.impl.ShiroAuthenticationFeature;
import org.apache.shiro.realm.Realm;
import org.osgi.annotation.bundle.Capability;
import org.osgi.framework.Bundle;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jaxrs.whiteboard.annotations.RequireJaxrsWhiteboard;

@Capability(attribute={"objectClass:List<String>='javax.ws.rs.core.Feature'", "osgi.jaxrs.name=aries.shiro.authc"}, namespace="osgi.service")
@RequireJaxrsWhiteboard
public class ShiroAuthenticationFeatureProvider
implements PrototypeServiceFactory<Feature> {
    private final List<Realm> realms;
    private final Set<ShiroAuthenticationFeature> features = Collections.synchronizedSet(new HashSet());

    public ShiroAuthenticationFeatureProvider(List<Realm> realms) {
        this.realms = realms;
    }

    public ShiroAuthenticationFeature getService(Bundle bundle, ServiceRegistration<Feature> registration) {
        ShiroAuthenticationFeature authenticationFeature = new ShiroAuthenticationFeature(this.realms);
        this.features.add(authenticationFeature);
        return authenticationFeature;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<Feature> registration, Feature service) {
        if (this.features.remove(service)) {
            ((ShiroAuthenticationFeature)service).close();
        }
    }

    public void close() {
        this.features.forEach(ShiroAuthenticationFeature::close);
    }
}

