/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.backoff;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.ObjectHelper;

public final class BackOff {
    public static final long NEVER = -1L;
    public static final Duration MAX_DURATION = Duration.ofMillis(Long.MAX_VALUE);
    public static final Duration DEFAULT_DELAY = Duration.ofSeconds(2L);
    public static final double DEFAULT_MULTIPLIER = 1.0;
    private Duration delay;
    private Duration maxDelay;
    private Duration maxElapsedTime;
    private Long maxAttempts;
    private Double multiplier;
    private boolean removeOnComplete;

    public BackOff() {
        this(DEFAULT_DELAY, MAX_DURATION, MAX_DURATION, Long.MAX_VALUE, 1.0, true);
    }

    public BackOff(Duration delay, Duration maxDelay, Duration maxElapsedTime, Long maxAttempts, Double multiplier, boolean removeOnComplete) {
        this.delay = ObjectHelper.supplyIfEmpty(delay, () -> DEFAULT_DELAY);
        this.maxDelay = ObjectHelper.supplyIfEmpty(maxDelay, () -> MAX_DURATION);
        this.maxElapsedTime = ObjectHelper.supplyIfEmpty(maxElapsedTime, () -> MAX_DURATION);
        this.maxAttempts = ObjectHelper.supplyIfEmpty(maxAttempts, () -> Long.MAX_VALUE);
        this.multiplier = ObjectHelper.supplyIfEmpty(multiplier, () -> 1.0);
        this.removeOnComplete = removeOnComplete;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public void setMaxDelay(Duration maxDelay) {
        this.maxDelay = maxDelay;
    }

    public Duration getMaxElapsedTime() {
        return this.maxElapsedTime;
    }

    public void setMaxElapsedTime(Duration maxElapsedTime) {
        this.maxElapsedTime = maxElapsedTime;
    }

    public Long getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(Long maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(Double multiplier) {
        this.multiplier = multiplier;
    }

    public boolean isRemoveOnComplete() {
        return this.removeOnComplete;
    }

    public void setRemoveOnComplete(boolean removeOnComplete) {
        this.removeOnComplete = removeOnComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("BackOff[");
        sb.append("delay=").append(this.delay.toMillis());
        if (this.maxDelay != MAX_DURATION) {
            sb.append(", maxDelay=").append(this.maxDelay.toMillis());
        }
        if (this.maxElapsedTime != MAX_DURATION) {
            sb.append(", maxElapsedTime=").append(this.maxElapsedTime.toMillis());
        }
        if (this.maxAttempts != Long.MAX_VALUE) {
            sb.append(", maxAttempts=").append(this.maxAttempts);
        }
        if (this.multiplier != 1.0) {
            sb.append(", multiplier=").append(this.multiplier);
        }
        sb.append(", remove=").append(this.removeOnComplete);
        sb.append("]");
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BackOff template) {
        return new Builder().read(template);
    }

    public static final class Builder {
        private Duration delay = DEFAULT_DELAY;
        private Duration maxDelay = MAX_DURATION;
        private Duration maxElapsedTime = MAX_DURATION;
        private Long maxAttempts = Long.MAX_VALUE;
        private Double multiplier = 1.0;
        private boolean removeOnComplete = true;

        public Builder read(BackOff template) {
            this.delay = template.delay;
            this.maxDelay = template.maxDelay;
            this.maxElapsedTime = template.maxElapsedTime;
            this.maxAttempts = template.maxAttempts;
            this.multiplier = template.multiplier;
            this.removeOnComplete = template.removeOnComplete;
            return this;
        }

        public Builder delay(Duration delay) {
            this.delay = delay;
            return this;
        }

        public Builder delay(long delay, TimeUnit unit) {
            return this.delay(Duration.ofMillis(unit.toMillis(delay)));
        }

        public Builder delay(long delay) {
            return this.delay(Duration.ofMillis(delay));
        }

        public Builder maxDelay(Duration maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder maxDelay(long maxDelay, TimeUnit unit) {
            return this.maxDelay(Duration.ofMillis(unit.toMillis(maxDelay)));
        }

        public Builder maxDelay(long maxDelay) {
            return this.maxDelay(Duration.ofMillis(maxDelay));
        }

        public Builder maxElapsedTime(Duration maxElapsedTime) {
            this.maxElapsedTime = maxElapsedTime;
            return this;
        }

        public Builder maxElapsedTime(long maxElapsedTime, TimeUnit unit) {
            return this.maxElapsedTime(Duration.ofMillis(unit.toMillis(maxElapsedTime)));
        }

        public Builder maxElapsedTime(long maxElapsedTime) {
            return this.maxElapsedTime(Duration.ofMillis(maxElapsedTime));
        }

        public Builder maxAttempts(Long attempts) {
            this.maxAttempts = attempts;
            return this;
        }

        public Builder multiplier(Double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public Builder removeOnComplete(boolean removeOnComplete) {
            this.removeOnComplete = removeOnComplete;
            return this;
        }

        public BackOff build() {
            return new BackOff(this.delay, this.maxDelay, this.maxElapsedTime, this.maxAttempts, this.multiplier, this.removeOnComplete);
        }
    }
}

