/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: TestDOMXDA.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/

package org.ten60.netkernel.xml.xda;

import org.ten60.netkernel.xml.util.XMLUtils;
import java.io.*;
import org.w3c.dom.*;
/**
 *
 * @author  pjr
 */
public class TestDOMXDA {
	
	public static final String doc1="<a att1=\"one\"><b>SomeText</b></a>";
	public static final String doc2="<c att2=\"two\"/>";
	
	/** Creates a new instance of TestDOMXDA */
	public TestDOMXDA() {
	}
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args)
	{	try
		{	Document a=XMLUtils.getInstance().parse(new StringReader(doc1));
			Document b=XMLUtils.getInstance().parse(new StringReader(doc2));
		
			DOMXDA xda1=new DOMXDA(a,null);
			DOMXDA xda2=new DOMXDA(b,null);
			
			System.out.println(xda1.toString(true));
			xda1.setText("/a", "Some new text set on document element" );
			xda1.appendPath("/a", "c", "This was added with appendPath" );
			xda1.applyNS("/a", "namespace",  "http://1060.org/test");
			xda1.append(xda2, "/", "/namespace:a");
			xda1.setText("/namespace:a/c", "This text was added after appending this element to /namespace:a" );
			xda1.append(xda2, "/c/@att2", "/namespace:a");
			xda1.delete("/namespace:a/c/@att2");
			xda1.removeNS("/namespace:a/namespace:b", "namespace" );
			xda1.delete("/namespace:a/namespace:c");
			System.out.println(xda1.toString(true));
			
			IXDAIterator i=xda1.iterator("/namespace:a/*");
			while(i.hasNext())
			{	i.next();
				System.out.println("Element: "+i.eval("name(.)").getStringValue());
				System.out.println(i.getText(".", true));
				
				i.append(xda2,"/",".");
			}
			
			System.out.println(xda1.toString(true));
			
			Document d=xda1.getFragment("/namespace:a/b");
			System.out.println(XMLUtils.getInstance().toXML(d, true, true));
			
			System.out.println("Test getPrefix "+ xda1.getPrefix("http://1060.org/test"));
			
			
			xda1.replace(xda2, "/", "/");
			xda1.rename("/*", "root");
			xda1.appendPath("/root", "b/c/d", null);
			xda1.replaceByText("/root/b/c/d", "I used to be element d - now I'm just text");
			xda1.appendPath("/root/b/c", "@attributetoqualitycode", "OH Yeah");
			System.out.println(xda1.toString(true));
			xda1.move("/root/b/c", "/root");
			xda1.move("/root/c/@attributetoqualitycode", "/root");
			xda1.move("/root/c/text()", "/root/b");
			xda1.move("/root/@att2", "/root/c");
			System.out.println(xda1.toString(true));
			
		}
		catch(Exception e)
		{	e.printStackTrace();
		}
	}
	
}
