/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: IXDAReadOnly.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xda;
import java.io.*;
/**
 *
 * @author  pjr
 */
public interface IXDAReadOnly
{	
	/** Evaluate the xpath against the document returning an IXPathResult
	 * @exception XPathLocationException throw if the xpath is malformed
	 */
	IXPathResult eval(String aTargetXPath) throws XPathLocationException;
	/** Evaluate and xpath against the document returning a boolean result
	 * @exception XPathLocationException throw if the xpath is malformed
	 */
	boolean isTrue(String aTargetXPath) throws XPathLocationException;
	/** Return the text that is contained at the element located using an XPath
	 * @param aTargetXPath the xpath
	 * @param aTrim if true trim whitespace from the String
	 * @exception XPathLocationException throw if the xpath is malformed or
	 * doesn't point to a single unique element
	 * @return the string
	 */
	String getText(String aTargetXPath, boolean aTrim)
		throws XPathLocationException;
	/** Return an iterator over all elements that match the an XPath
	 * @param aTargetXPath the xpath
	 * @exception XPathLocationException throw if the xpath is malformed
	 * @return the iterator
	 */
	IXDAReadOnlyIterator readOnlyIterator(String aTargetXPath) throws XPathLocationException;
	/** Serialize part of the document
	 * @param aWriter the writer to write the serialized document to
	 * @param aTargetXPath the xpath
	 * @param indent true if the document should be re-indented
	 * @exception XPathLocationException throw if the xpath is malformed or
	 * doesn't point to a single unique element
	 * @exception IOException throw if the writer cannot be written to
	 */
	void serialize(Writer aWriter, String aTargetXPath, boolean indent)	throws XPathLocationException, IOException;
	/** Serialize the whole document
	 * @param aWriter the writer to write the serialized document to
	 * @param indent true if the document should be re-indented
	 * @exception IOException throw if the writer cannot be written to
	 */
	void serialize(Writer aWriter, boolean indent)	throws IOException;
}