/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XAHelperImpl.java,v $
  Version:       $Name:  $ $Revision: 1.9 $
  Last Modified: $Date: 2004/09/28 15:03:32 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xahelper;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;

import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.layer1.meta.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.container.Container;

import org.xml.sax.*;
import org.w3c.dom.*;
import javax.xml.transform.*;
import java.io.*;
import java.util.*;
import java.net.*;

/**
 * An implementation of XAHelper, XAHelperExtra
 * @author  tab
 */
public class XAHelperImpl implements XAHelper, XAHelperExtra
{
	private CompoundURIdentifier mURI;
	private URI mCWU;
	private URIdentifier mCWURIdentifier;
	private URRequest mRequest;
	private XAccessor mAccessor;
	private CheapMap mDependencies;
	
	static final String ACTIVE="active";
	
	/** Creates a new instance of XAHelperImpl */
	public XAHelperImpl(URRequest aRequest, XAccessor aAccessor, Map aArgumentDeclarations, boolean aKeepDependencies) throws NetKernelException
	{	mRequest=aRequest;
		mURI = new CompoundURIdentifier(aRequest.getURI());
		mCWURIdentifier = aRequest.getCWU();
		if (mCWURIdentifier!=null)
		{	mCWU = URI.create(mCWURIdentifier.toString());
		}
		mAccessor=aAccessor;
		if (aKeepDependencies)
		{	mDependencies = new CheapMap(4);
			mDependencies.put(aAccessor.getURI(),aAccessor);
			for (Iterator i=mRequest.getArgs().iterator(); i.hasNext(); )
			{	URIdentifier argURI = (URIdentifier)i.next();
				IURRepresentation argValue=mRequest.getArg(argURI);
				mDependencies.put(argURI,argValue);
			}
		}
		if (aArgumentDeclarations!=null)
		{	validateRequest(mURI,aArgumentDeclarations);
		}
	}
	
	public IXAspect getOperand() throws NetKernelException
	{	return (IXAspect)innerGetResource(OPERAND,getURIdentifier(OPERAND),IXAspect.class).getAspect(IXAspect.class);
	}
	
	public IURRepresentation getOperand(Class aClass) throws NetKernelException
	{	return innerGetResource(OPERAND,getURIdentifier(OPERAND),aClass);
	}
	
	public IXAspect getOperator() throws NetKernelException
	{	return (IXAspect)innerGetResource(OPERATOR,getURIdentifier(OPERATOR),IXAspect.class).getAspect(IXAspect.class);
	}
	
	public IURRepresentation getOperator(Class aClass) throws NetKernelException
	{	return innerGetResource(OPERATOR,getURIdentifier(OPERATOR),aClass);
	}
	
	public IXAspect getParameter()  throws NetKernelException
	{	return (IXAspect)innerGetResource(PARAMETER,getURIdentifier(PARAMETER),IXAspect.class).getAspect(IXAspect.class);
	}
	
	public IURRepresentation getParameter(Class aClass) throws NetKernelException
	{	return innerGetResource(PARAMETER,getURIdentifier(PARAMETER),aClass);
	}
	
	public boolean hasOperand()
	{	return mURI.get(OPERAND)!=null;
	}
	
	public boolean hasOperator()
	{	return mURI.get(OPERATOR)!=null;
	}
	
	public boolean hasParameter()
	{	return mURI.get(PARAMETER)!=null;
	}
	
	public URI getURI(String aArgument) throws java.net.URISyntaxException
	{	URI result=null;
		String uriString = mURI.get(aArgument);
		if (uriString!=null)
		{	result = new URI(uriString);
		}
		return result;
	}
	
	private URIdentifier getURIdentifier(String argument) throws NetKernelException
	{	URIdentifier result=null;
		String uriString = mURI.get(argument);
		if (uriString!=null)
		{	result = new URIdentifier(uriString);
		}
		else
		{	throw new NetKernelException("Expected Argument Missing","A necessary argument of name "+argument+" was not supplied with request",argument);
		}
		return result;
	}
	
	public String getType()
	{	return mURI.getType();
		
	}
	
	public URI getCurrentWorkingURI()
	{	return mCWU;
	}
	
	public IURMeta getDependencyMeta(String aMimeType, int aCreationCost)
	{	return getDependencyMeta(aMimeType,aCreationCost,0,null);
	}
	
	public DependencyMeta getDependencyMeta(String aMimeType, int aCreationCost, int aUsageCost, List aOnUsageDependencies)
	{	DependencyMeta meta = new DependencyMeta(aMimeType,aCreationCost,aUsageCost);
		if (mDependencies!=null)
		{	for (Iterator i = mDependencies.values().iterator(); i.hasNext(); )
			{	IURRepresentation dependency = (IURRepresentation)i.next();
				if (aOnUsageDependencies==null || !aOnUsageDependencies.contains(dependency))
				{	// add creation dependency
					meta.addDependency(dependency);
				}
				else
				{	// add usage dependency
					meta.addUsageDependency(dependency);
				}
			}
		}
		return meta;
	}
	
	public IXAspect getXResource(URI aURI) throws NetKernelException
	{	return (IXAspect)innerGetResource("resource",new URIdentifier(aURI.toString()),IXAspect.class).getAspect(IXAspect.class);
	}
	
	public IURRepresentation getResource(URI aURI, Class aClass) throws NetKernelException
	{	return innerGetResource("resource",new URIdentifier(aURI.toString()), aClass);
	}
	
	public void setResource(URI aURI, IURRepresentation aProxy) throws NetKernelException
	{	URIdentifier ui=new URIdentifier(aURI.toString());
		URRequest request = new URRequest(ui, null, mRequest.getSession(), mAccessor.getModule(), URRequest.RQT_SINK, mCWURIdentifier, mRequest, IURAspect.class);
		request.addArg(URRequest.URI_SYSTEM, aProxy);
		mAccessor.getScheduler().requestSynch(request);
	}
	
	/* Get an XML Resource by URI - ensures URI with XPointer fragments
	 * always request non-fragment URI from Kernel
	 */
	private IURRepresentation innerGetResource(String aName, URIdentifier aURI, Class aClass) throws NetKernelException
	{	return innerGetResource(aName,aURI,aClass, null);
	}
	private IURRepresentation innerGetResource(String aName, URIdentifier aURI, Class aClass, Map aURIToValue) throws NetKernelException
	{	try
		{	IURRepresentation proxy = null;
			String fragment = aURI.getFragment();
			URIdentifier withoutFragment=aURI;
			if (fragment!=null)
			{	withoutFragment=aURI.withoutFragment();
			}
			
			if (aURIToValue==null)
			{	//look on request for by-value
				proxy=mRequest.getArg(withoutFragment);
				
				/*
				if (proxy==null)
				{	//look to see if we have already requested it
					proxy = (IURRepresentation)mDependencies.get(withoutFragment);
					if (proxy!=null && proxy.getMeta().isExpired())
					{	proxy=null; // don't use if expired
					}
				}
				 */
				if (proxy!=null)
				{	if (fragment!=null)
					{	// apply fragment to by value argument
						proxy=mAccessor.fragment(proxy,fragment,aClass,mRequest);
					}
					else
					{	if (!proxy.hasAspect(aClass))
						{	// transrepresent a by value argument
							proxy = mAccessor.transrepresent(aURI, proxy, aClass, mRequest);
						}
					}
				}
				if (proxy==null)
				{	// make a simple request
					proxy = mAccessor.getProxy(aURI, aClass, mRequest);
				}
			}
			else
			{	// request with by value arguments
				proxy = requestWithValues(aURI,aClass,mRequest,aURIToValue);
			}
			
			// add to our dependencies
			if (mDependencies!=null)
			{	mDependencies.put(aURI, proxy);
			}
			
			return proxy;
		}
		catch (NetKernelException e)
		{	NetKernelException nke = new NetKernelException("Unhandled Exception in XAccessor","whilst requesting "+aName,null);
			nke.addCause(e);
			throw nke;
		}
	}
	
	private IURRepresentation requestWithValues(URIdentifier aURI, Class aAspectClass, URRequest aParent, Map aURIToValue) 
		throws NetKernelException
	{	
		URRequest request = new URRequest(aURI, null, aParent.getSession(), mAccessor.getModule(), URRequest.RQT_SOURCE, aParent.getCWU(), aParent, aAspectClass);
		for (Iterator i = aURIToValue.entrySet().iterator(); i.hasNext(); )
		{	Map.Entry arg = (Map.Entry)i.next();
			request.addArg(new URIdentifier(arg.getKey().toString()), (IURRepresentation)arg.getValue());
		}
		URResult result = mAccessor.getScheduler().requestSynch(request);
		IURRepresentation representation = result.getResource();		
		return representation;
	}
	
	
	
	public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException
	{
		URI resource=URI.create(aPublicId);
		if(!resource.isAbsolute())
		{	resource=getCurrentWorkingURI().resolve(resource);
		}
		URIdentifier uri = new URIdentifier(resource.toString());
		try
		{	Class rbc = IAspectReadableBinaryStream.class;
			IAspectReadableBinaryStream proxy=(IAspectReadableBinaryStream)innerGetResource("resource",uri,rbc).getAspect(rbc);
			InputStreamReader reader = new InputStreamReader(proxy.getInputStream());
			return new InputSource(reader);
		}
		catch(Exception e)
		{	throw new SAXException("Resource "+aPublicId+" could not be resolved");
		}
	}
	
	public Source resolve(String href, String base) throws TransformerException
	{	URI resource=URI.create(href);
		if(!resource.isAbsolute())
		{	resource=getCurrentWorkingURI().resolve(resource);
		}
		URIdentifier uri = new URIdentifier(resource.toString());
		try
		{	IXAspect proxy=(IXAspect)innerGetResource("resource",uri,IXAspect.class).getAspect(IXAspect.class);
			return new javax.xml.transform.dom.DOMSource(proxy.getReadOnlyDocument());
		}
		catch(NetKernelException e)
		{	throw new TransformerException("Resource "+base+" "+href+" could not be accessed");
		}
	}
	
	public URRequest getRequest()
	{	return mRequest;
	}
	
	public Container getContainer()
	{	return mAccessor.getContainer();
	}
	
	private void validateRequest(CompoundURIdentifier aURI, Map aArguments) throws NetKernelException
	{
		//validate arguments are expected and are fragmented as expected
		for (Iterator i = aURI.getArgs(); i.hasNext(); )
		{	CompoundURIdentifier.CompoundURIStruct arg = (CompoundURIdentifier.CompoundURIStruct)i.next();
			String argName = arg.getKey();
			XAArgumentDeclaration declaration = (XAArgumentDeclaration)aArguments.get(argName);
			if (declaration==null)
			{	throw new NetKernelException(getAccessorName()+" received unexpected "+argName+" argument");
			}
			/*
			URIdentifier uri = new URIdentifier(arg.getURI());
			if (!declaration.acceptsFragments() && uri.getFragment()!=null)
			{	throw new NetKernelException(getAccessorName()+" received unexpected fragment on "+argName+" argument");
			}
		*/
		}
		// validate that all mandatory arguments are there as expected
		for (Iterator i = aArguments.entrySet().iterator(); i.hasNext(); )
		{	Map.Entry entry = (Map.Entry)i.next();
			String argName = (String)entry.getKey();
			XAArgumentDeclaration declaration = (XAArgumentDeclaration)entry.getValue();
			if (declaration.isRequired() && aURI.get(argName)==null)
			{	throw new NetKernelException(getAccessorName()+" expected mandatory "+argName+" argument");
			}
		}
		
	}
	
	private String getAccessorName()
	{	String name = mAccessor.getClass().getName();
		name = name.substring(name.lastIndexOf('.')+1);
		return name;
	}	
	
	/** Request a resource with optional pass-by-value arguments
	  @param aURI the type component of the active uri
	  @param aAspectClass the result must have this aspect
	  @param aURIToValue a map of <code>URI</code> to <code>IURRepresentation</code>
	  @exception NetKernelException thrown if we fail to request the resource sucessfully
	 *@return A Representation of the requested resource
	 */
	public IURRepresentation requestResourceWithValues(URI aURI, Class aAspectClass, Map aURIToValue) throws NetKernelException
	{	return innerGetResource("resource",new URIdentifier(aURI.toString()),aAspectClass,aURIToValue);
	}

}