/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: DOM2SAX.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/

package org.ten60.netkernel.xml.util;

import org.w3c.dom.*;
import org.xml.sax.*;
//import org.xml.sax.helpers.*;
import javax.xml.parsers.*;
import java.io.*;

/**
 * A utility class to SAX parse an XMLBean, DOM Node or IReadable.
 * @author  pjr
 */
public class DOM2SAX {
	
	private Node mNode;
	private ContentHandler mContentHandler;
	
	/** Creates a new instance of DOM2SAX */
	public DOM2SAX(Node aNode) {
		mNode=aNode;
	}
	
	/* Parse the registered object */
	public void parse() throws SAXException
	{	if(mContentHandler!=null){	
			try{
				//Expensive way - need a DOM2SAX utillity
				StringWriter sw=new StringWriter(2048);
				XMLUtils.getInstance().toXML(sw,mNode,false,false);
				InputSource is=new InputSource(new StringReader(sw.toString()));
				SAXParserFactory spf=SAXParserFactory.newInstance();
				spf.setNamespaceAware(true);
				SAXParser sp=spf.newSAXParser();
				//sp.parse(is,mContentHandler);
				XMLReader xr=sp.getXMLReader();
				xr.setContentHandler(mContentHandler);
				xr.parse(is);
			}
			catch(IOException e)
			{ throw new SAXException("IOException caused by "+e.getMessage());
			}
			catch(ParserConfigurationException e)
			{	throw new SAXException("ParserConfigurationException caused by "+e.getMessage());
			}
		}
		else throw new SAXException("No SAX content handler set");
	}
	
	/* Set a SAX ContentHandler to receive SAX Events */
	public void setContentHandler(ContentHandler aContentHandler)
	{
		mContentHandler=aContentHandler;
	}
}
