/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ApplyNamespaceHandler.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/

package org.ten60.netkernel.xml.util;

import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import java.io.*;

/**
 *
 * @author  pjr
 */
public class ApplyNamespaceHandler implements org.xml.sax.ContentHandler{
	
	private Document mDocument;
	private Node mPointer;
	private String mURI;
	private String mPrefix;
	private boolean mParseCompleted=false;
	
	/** Creates a new instance of ApplyNamespaceHandler */
	public ApplyNamespaceHandler(String aURI, String aPrefix) {
		mURI=aURI;
		mPrefix=aPrefix;
		try
		{
			DocumentBuilderFactory dbf=DocumentBuilderFactory.newInstance();
			DocumentBuilder db=dbf.newDocumentBuilder();
			mDocument = db.newDocument();
		}
		catch(Exception e)
		{ e.printStackTrace();
		}
	}
	
	public Document getDocument() throws SAXException
	{	if(mParseCompleted) return mDocument;
		else throw new SAXException("Document has not been parsed");
	}
		
	/** Receive notification of character data.
	 *
	 * <p>The Parser will call this method to report each chunk of
	 * character data.  SAX parsers may return all contiguous character
	 * data in a single chunk, or they may split it into several
	 * chunks; however, all of the characters in any single event
	 * must come from the same external entity so that the Locator
	 * provides useful information.</p>
	 *
	 * <p>The application must not attempt to read from the array
	 * outside of the specified range.</p>
	 *
	 * <p>Note that some parsers will report whitespace in element
	 * content using the {@link #ignorableWhitespace ignorableWhitespace}
	 * method rather than this one (validating parsers <em>must</em>
	 * do so).</p>
	 *
	 * @param ch The characters from the XML document.
	 * @param start The start position in the array.
	 * @param length The number of characters to read from the array.
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 * @see #ignorableWhitespace
	 * @see org.xml.sax.Locator
	 *
	 */
	public void characters(char[] ch, int start, int length) throws SAXException {
		StringWriter sw=new StringWriter();
		sw.write(ch, start, length);
		Text t=mDocument.createTextNode(sw.toString());
		mPointer.appendChild(t);
	}
	
	/** Receive notification of the end of a document.
	 *
	 * <p>The SAX parser will invoke this method only once, and it will
	 * be the last method invoked during the parse.  The parser shall
	 * not invoke this method until it has either abandoned parsing
	 * (because of an unrecoverable error) or reached the end of
	 * input.</p>
	 *
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 * @see #startDocument
	 *
	 */
	public void endDocument() throws SAXException {
		mParseCompleted=true;
	}
	
	/** Receive notification of the end of an element.
	 *
	 * <p>The SAX parser will invoke this method at the end of every
	 * element in the XML document; there will be a corresponding
	 * {@link #startElement startElement} event for every endElement
	 * event (even when the element is empty).</p>
	 *
	 * <p>For information on the names, see startElement.</p>
	 *
	 * @param uri The Namespace URI, or the empty string if the
	 *        element has no Namespace URI or if Namespace
	 *        processing is not being performed.
	 * @param localName The local name (without prefix), or the
	 *        empty string if Namespace processing is not being
	 *        performed.
	 * @param qName The qualified XML 1.0 name (with prefix), or the
	 *        empty string if qualified names are not available.
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 *
	 */
	public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
		mPointer=mPointer.getParentNode();
	}
	
	/** End the scope of a prefix-URI mapping.
	 *
	 * <p>See {@link #startPrefixMapping startPrefixMapping} for
	 * details.  This event will always occur after the corresponding
	 * {@link #endElement endElement} event, but the order of
	 * {@link #endPrefixMapping endPrefixMapping} events is not otherwise
	 * guaranteed.</p>
	 *
	 * @param prefix The prefix that was being mapping.
	 * @exception org.xml.sax.SAXException The client may throw
	 *            an exception during processing.
	 * @see #startPrefixMapping
	 * @see #endElement
	 *
	 */
	public void endPrefixMapping(String prefix) throws SAXException {
	}
	
	/** Receive notification of ignorable whitespace in element content.
	 *
	 * <p>Validating Parsers must use this method to report each chunk
	 * of whitespace in element content (see the W3C XML 1.0 recommendation,
	 * section 2.10): non-validating parsers may also use this method
	 * if they are capable of parsing and using content models.</p>
	 *
	 * <p>SAX parsers may return all contiguous whitespace in a single
	 * chunk, or they may split it into several chunks; however, all of
	 * the characters in any single event must come from the same
	 * external entity, so that the Locator provides useful
	 * information.</p>
	 *
	 * <p>The application must not attempt to read from the array
	 * outside of the specified range.</p>
	 *
	 * @param ch The characters from the XML document.
	 * @param start The start position in the array.
	 * @param length The number of characters to read from the array.
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 * @see #characters
	 *
	 */
	public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
		StringWriter sw=new StringWriter();
		sw.write(ch, start, length);
		Text t=mDocument.createTextNode(sw.toString());
		mPointer.appendChild(t);
	}
	
	/** Receive notification of a processing instruction.
	 *
	 * <p>The Parser will invoke this method once for each processing
	 * instruction found: note that processing instructions may occur
	 * before or after the main document element.</p>
	 *
	 * <p>A SAX parser must never report an XML declaration (XML 1.0,
	 * section 2.8) or a text declaration (XML 1.0, section 4.3.1)
	 * using this method.</p>
	 *
	 * @param target The processing instruction target.
	 * @param data The processing instruction data, or null if
	 *        none was supplied.  The data does not include any
	 *        whitespace separating it from the target.
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 *
	 */
	public void processingInstruction(String target, String data) throws SAXException {
		ProcessingInstruction pi=mDocument.createProcessingInstruction(target, data);
		mPointer.appendChild(pi);
	}
	
	/** Receive an object for locating the origin of SAX document events.
	 *
	 * <p>SAX parsers are strongly encouraged (though not absolutely
	 * required) to supply a locator: if it does so, it must supply
	 * the locator to the application by invoking this method before
	 * invoking any of the other methods in the ContentHandler
	 * interface.</p>
	 *
	 * <p>The locator allows the application to determine the end
	 * position of any document-related event, even if the parser is
	 * not reporting an error.  Typically, the application will
	 * use this information for reporting its own errors (such as
	 * character content that does not match an application's
	 * business rules).  The information returned by the locator
	 * is probably not sufficient for use with a search engine.</p>
	 *
	 * <p>Note that the locator will return correct information only
	 * during the invocation of the events in this interface.  The
	 * application should not attempt to use it at any other time.</p>
	 *
	 * @param locator An object that can return the location of
	 *                any SAX document event.
	 * @see org.xml.sax.Locator
	 *
	 */
	public void setDocumentLocator(Locator locator) {
	}
	
	/** Receive notification of a skipped entity.
	 *
	 * <p>The Parser will invoke this method once for each entity
	 * skipped.  Non-validating processors may skip entities if they
	 * have not seen the declarations (because, for example, the
	 * entity was declared in an external DTD subset).  All processors
	 * may skip external entities, depending on the values of the
	 * <code>http://xml.org/sax/features/external-general-entities</code>
	 * and the
	 * <code>http://xml.org/sax/features/external-parameter-entities</code>
	 * properties.</p>
	 *
	 * @param name The name of the skipped entity.  If it is a
	 *        parameter entity, the name will begin with '%', and if
	 *        it is the external DTD subset, it will be the string
	 *        "[dtd]".
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 *
	 */
	public void skippedEntity(String name) throws SAXException {
	}
	
	/** Receive notification of the beginning of a document.
	 *
	 * <p>The SAX parser will invoke this method only once, before any
	 * other methods in this interface or in {@link org.xml.sax.DTDHandler
	 * DTDHandler} (except for {@link #setDocumentLocator
	 * setDocumentLocator}).</p>
	 *
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 * @see #endDocument
	 *
	 */
	public void startDocument() throws SAXException {
		mPointer=mDocument;
	}
	
	/** Receive notification of the beginning of an element.
	 *
	 * <p>The Parser will invoke this method at the beginning of every
	 * element in the XML document; there will be a corresponding
	 * {@link #endElement endElement} event for every startElement event
	 * (even when the element is empty). All of the element's content will be
	 * reported, in order, before the corresponding endElement
	 * event.</p>
	 *
	 * <p>This event allows up to three name components for each
	 * element:</p>
	 *
	 * <ol>
	 * <li>the Namespace URI;</li>
	 * <li>the local name; and</li>
	 * <li>the qualified (prefixed) name.</li>
	 * </ol>
	 *
	 * <p>Any or all of these may be provided, depending on the
	 * values of the <var>http://xml.org/sax/features/namespaces</var>
	 * and the <var>http://xml.org/sax/features/namespace-prefixes</var>
	 * properties:</p>
	 *
	 * <ul>
	 * <li>the Namespace URI and local name are required when
	 * the namespaces property is <var>true</var> (the default), and are
	 * optional when the namespaces property is <var>false</var> (if one is
	 * specified, both must be);</li>
	 * <li>the qualified name is required when the namespace-prefixes property
	 * is <var>true</var>, and is optional when the namespace-prefixes property
	 * is <var>false</var> (the default).</li>
	 * </ul>
	 *
	 * <p>Note that the attribute list provided will contain only
	 * attributes with explicit values (specified or defaulted):
	 * #IMPLIED attributes will be omitted.  The attribute list
	 * will contain attributes used for Namespace declarations
	 * (xmlns* attributes) only if the
	 * <code>http://xml.org/sax/features/namespace-prefixes</code>
	 * property is true (it is false by default, and support for a
	 * true value is optional).</p>
	 *
	 * @param uri The Namespace URI, or the empty string if the
	 *        element has no Namespace URI or if Namespace
	 *        processing is not being performed.
	 * @param localName The local name (without prefix), or the
	 *        empty string if Namespace processing is not being
	 *        performed.
	 * @param qName The qualified name (with prefix), or the
	 *        empty string if qualified names are not available.
	 * @param atts The attributes attached to the element.  If
	 *        there are no attributes, it shall be an empty
	 *        Attributes object.
	 * @exception org.xml.sax.SAXException Any SAX exception, possibly
	 *            wrapping another exception.
	 * @see #endElement
	 * @see org.xml.sax.Attributes
	 *
	 */
	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
		if(namespaceURI.equals("") || namespaceURI==null){
			Element e=mDocument.createElementNS(mURI, mPrefix+":"+localName);
			for(int i=0;i<atts.getLength();i++)
			{	e.setAttributeNS(atts.getURI(i), atts.getQName(i), atts.getValue(i));
			}
			mPointer.appendChild(e);
			mPointer=e;
		}
		else throw new SAXException("Element "+qName+" already has namespace "+namespaceURI);
	}
	/** Begin the scope of a prefix-URI Namespace mapping.
	 *
	 * <p>The information from this event is not necessary for
	 * normal Namespace processing: the SAX XML reader will
	 * automatically replace prefixes for element and attribute
	 * names when the <code>http://xml.org/sax/features/namespaces</code>
	 * feature is <var>true</var> (the default).</p>
	 *
	 * <p>There are cases, however, when applications need to
	 * use prefixes in character data or in attribute values,
	 * where they cannot safely be expanded automatically; the
	 * start/endPrefixMapping event supplies the information
	 * to the application to expand prefixes in those contexts
	 * itself, if necessary.</p>
	 *
	 * <p>Note that start/endPrefixMapping events are not
	 * guaranteed to be properly nested relative to each-other:
	 * all startPrefixMapping events will occur before the
	 * corresponding {@link #startElement startElement} event,
	 * and all {@link #endPrefixMapping endPrefixMapping}
	 * events will occur after the corresponding {@link #endElement
	 * endElement} event, but their order is not otherwise
	 * guaranteed.</p>
	 *
	 * <p>There should never be start/endPrefixMapping events for the
	 * "xml" prefix, since it is predeclared and immutable.</p>
	 *
	 * @param prefix The Namespace prefix being declared.
	 * @param uri The Namespace URI the prefix is mapped to.
	 * @exception org.xml.sax.SAXException The client may throw
	 *            an exception during processing.
	 * @see #endPrefixMapping
	 * @see #startElement
	 *
	 */
	public void startPrefixMapping(String prefix, String uri) throws SAXException {
	}
	
}
