/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SAXToBinaryStream.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2004/09/24 22:36:56 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.transrepresentation.*;
import org.ten60.netkernel.layer1.representation.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.apache.xml.serializer.*;
import javax.xml.transform.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.util.*;
import java.io.*;

/**
 * Serialises a SAX stream into a binary stream
 * @author  tab
 */
public class SAXToBinaryStream extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectSAX.class) && ( aTo.isAssignableFrom(IAspectBinaryStream.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	try
		{	IAspectSAX sax = (IAspectSAX)aFrom.getAspect(IAspectSAX.class);
			
			ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
			Properties p=OutputPropertiesFactory.getDefaultMethodProperties("xml");
			Serializer s=SerializerFactory.getSerializer(p);
			s.setOutputStream(baos);
			ContentHandler ch = s.asContentHandler();
			XMLReader xr=XMLReaderFactory.createXMLReader();
			xr.setContentHandler(ch);
			
			// this serializer has no way to receive lexical events that we can see- so this is lost
			List usageDependencies = new ArrayList(8);
			sax.handleContent(xr,usageDependencies);
			ByteArrayAspect aspect = new ByteArrayAspect(baos);
			DependencyMeta meta = new DependencyMeta(aFrom, 8);
			for (Iterator i = usageDependencies.iterator(); i.hasNext(); )
			{	IURRepresentation dependency = (IURRepresentation)i.next();
				meta.addDependency(dependency);
			}
			return new MonoRepresentationImpl(meta,aspect);
		} catch (Exception e)
		{	NetKernelException ex=new NetKernelException("Unhandled Exception in SAXToBinaryStream");
			ex.addCause(e);
			throw ex;
		}		
	}
}