/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: TransportInitiatedSession.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2004/02/02 14:25:21 $
 *****************************************************************************/
package org.ten60.transport.jetty;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.transport.TransportManager;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

/**
 *
 * @author  tab
 */
public final class TransportInitiatedSession implements IRequestorSession
{
	private long mCreationTime;
	private CheapMap mTokens;
	
	public static final String KEY_CLIENT_ID="clientId";
	
	/** Creates a new instance of TransportInitiatedSession */
	public TransportInitiatedSession(String aTransportId, String aClient)
	{	
		mCreationTime = System.currentTimeMillis();
		mTokens = new CheapMap(3);
		IURMeta meta = new MetaImpl("text/plain", 0, 0);
		mTokens.put(KEY_CLIENT_ID, StringAspect.create(meta, aClient));
		mTokens.put(IRequestorSession.SESSION_INITIATOR_KEY, StringAspect.create(meta, aTransportId));
	}
	
	public long getCreationTime()
	{	return mCreationTime;
	}
	
	public IURRepresentation get(String aKey)
	{	return (IURRepresentation)mTokens.get(aKey);
	}
	
	public void set(String aKey, IURRepresentation aRepresentation)
	{	mTokens.put(aKey,aRepresentation);
	}
	
	public java.util.Set keySet()
	{	return mTokens.keySet();
	}	
	
}