/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: HttpHandler.java,v $
  Version:       $Name:  $ $Revision: 1.47 $
  Last Modified: $Date: 2004/02/25 10:18:08 $
 *****************************************************************************/
package org.ten60.transport.jetty;

import org.ten60.transport.http.cookie.representation.*;
import org.ten60.transport.http.parameter.representation.*;
import org.ten60.transport.http.request.representation.*;

import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

import com.ten60.netkernel.transport.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.module.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;

import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.http.*;

import org.w3c.dom.*;
import javax.servlet.http.Cookie;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import java.net.*;

/**
 * Jetty Handler for all our requests
 * @author  pjr
 */
public class HttpHandler extends AbstractHttpHandler
{
	private JettyTransport mTransport;
	//private String mTransportName;
	private String mExceptionHandler;
	private int mMaxContentLength=25000;
	private static final long EXPIRY_PERIOD = 24*60*60*1000; // 24 hours
	
	public HttpHandler(String aExceptionHandler)
	{	if (aExceptionHandler!=null && aExceptionHandler.length()>0)
		{	mExceptionHandler = aExceptionHandler;
		}
	}
	
	//public void setTransportName(String aName){ mTransportName=aName;}
	public void setMaxContentLength(int aSize){ mMaxContentLength=aSize;}
	
	private boolean checkParameterSize(HttpRequest aRequest)
	{	Iterator i=aRequest.getParameterNames().iterator();
		int totalSize=0;
		while(i.hasNext())
		{	String name=(String)i.next();
			Iterator j=aRequest.getParameterValues(name).iterator();
			while(j.hasNext())
			{	String value=(String)j.next();
				totalSize+=value.length();
			}
		}
		return totalSize<mMaxContentLength;
	}
	
	public void handle(String str, String str1, HttpRequest httpRequest, HttpResponse httpResponse)
	throws HttpException, IOException
	{	if (SysLogger.shouldLog(SysLogger.FINE,this))
		{	SysLogger.log(SysLogger.FINE, this,  httpRequest.getRequestLine());
		}
		try
		{   String requestURI = convertURI(httpRequest);
			HashMap mprParts=null;
			ArrayList mprURIs=null;			
			
			// handle any attatched data
			String mimetype=httpRequest.getMimeType();
			HashMap multipartNVP=null;
			if (mimetype!=null)
			{	// handle file uploads
				if(mimetype.equals("multipart/form-data"))
				{	MultiPartRequest mpr=new MultiPartRequest(httpRequest);
					String[] names=mpr.getPartNames();
					mprParts=new HashMap(names.length);
					mprURIs=new ArrayList(names.length);
					multipartNVP=new HashMap(names.length);
					for(int i=0; i<names.length;i++)
					{	String filename=mpr.getFilename(names[i]);
						if(filename!=null)
						{	URIdentifier partURI = URIdentifier.getUnique("literal:param");
							mprURIs.add(partURI);
							String suffix = "+"+names[i]+"@";
							requestURI+=suffix+partURI.toString();
							mprParts.put(partURI, ParameterUploadAspect.create(new AlwaysExpiredMeta("type/unknown",0), mpr,names[i], filename));
							multipartNVP.put(names[i], new ByteArrayInputStream(filename.getBytes()));
						}
						else //Must be mulitpart form data so add to NVP
						{	multipartNVP.put(names[i], mpr.getInputStream(names[i]));
						}
					}
				}
			}
			IURRepresentation paramNVP=null;
			//handle any regular post or get parameters
			if(httpRequest.getParameterNames().size()>0 && checkParameterSize(httpRequest))
			{	paramNVP=ParameterNVPAspect.create( new AlwaysExpiredMeta("text/nvp", 0),httpRequest);
			}
			else if(multipartNVP!=null)
			{	Set keys=multipartNVP.keySet();
				Iterator it=keys.iterator();
				StringBuffer sb=new StringBuffer(2048);
				sb.append("<nvp>");
				while(it.hasNext())
				{	String key=(String)it.next();
					InputStream is=(InputStream)multipartNVP.get(key);
					StringWriter sw=new StringWriter();
					while(is.available()>0)
					{	sw.write(is.read());
					}
					sb.append("<"+key+">");
					sb.append(sw.getBuffer());
					sb.append("</"+key+">");
					
				}
				sb.append("</nvp>");
				paramNVP=org.ten60.netkernel.layer1.representation.StringAspect.create( new AlwaysExpiredMeta("text/xml", 0), sb.toString());
			}
			// handle any other posted data - maybe XML
			if (paramNVP==null && mimetype!=null && !mimetype.equals("application/x-www-form-urlencoded"))
			{	IURMeta meta = new AlwaysExpiredMeta(mimetype,0);
				ByteArrayOutputStream baos = new ByteArrayOutputStream(httpRequest.getContentLength());
				Utils.pipe(httpRequest.getInputStream(), baos);
				paramNVP = ByteArrayAspect.create(meta,baos);
			}
			
			URIdentifier paramURI=null;
			if (paramNVP!=null)
			{	paramURI = URIdentifier.getUnique("literal:param");
				String suffix = "+param@";
				requestURI+=suffix+paramURI.toString();
			}
			
			IURRepresentation cjp=null;
			Cookie[] cookies=httpRequest.getCookies();
			if(cookies.length>0)
			{	List proxies = new ArrayList(cookies.length);
				for(int i=0; i<cookies.length; i++)
				{	proxies.add(CookieAspect.create(cookies[i]));
				}
				IURRepresentation vp = org.ten60.netkernel.layer1.representation.VoidAspect.create();
				cjp=MultiPartAspect.create(vp,proxies);
			}
			URIdentifier cookieURI=null;
			if (cjp!=null)
			{	cookieURI = URIdentifier.getUnique("literal:param");
				String suffix = "+cookie@";
				requestURI+=suffix+cookieURI.toString();
			}
			String id = httpRequest.getRemoteHost();
			
			TransportInitiatedSession session = new TransportInitiatedSession(getName(), id);
			IURRepresentation headerRepresentation=RequestHeaderAspect.create(new AlwaysExpiredMeta("http/request", 0), httpRequest);
			IURRepresentation HTTPURL=URIAspect.create(new AlwaysExpiredMeta("netkernel/uri", 0), URI.create(httpRequest.getURI().toString()));
			session.set("HTTPHeader",headerRepresentation);
			session.set("HTTPURL", HTTPURL);
			TransportManager tm=mTransport.getTransportManager();
			URRequest request = new URRequest(new URIdentifier(requestURI),tm,session, mTransport.getContext(), URRequest.RQT_SOURCE, null, null, IAspectBinaryStream.class);
			if (paramNVP!=null)
			{	request.addArg(paramURI,paramNVP);
			}
			if (cjp!=null)
			{	request.addArg(cookieURI,cjp);
			}
			if(mprURIs!=null)
			{	Iterator it=mprURIs.iterator();
				while(it.hasNext())
				{	URIdentifier uri=(URIdentifier)it.next();
					request.addArg(uri,(IURRepresentation)mprParts.get(uri));
				}
			}

			IURRepresentation response=tm.handleRequest(request,mTransport);
			if (response.hasAspect(NetKernelExceptionAspect.class))
			{	handleFailure(response,httpResponse,httpRequest);
			}
			else if (response.hasAspect(IAspectRedirectRequest.class))
			{	redirect(response, httpResponse);
			}
			else
			{	try
				{	outputOk(response,httpResponse, requestURI);
				}
				catch (NetKernelException e)
				{	IURRepresentation error = NetKernelExceptionAspect.create(e);
					handleFailure(error,httpResponse,httpRequest);
				}
			}
		}	catch (Throwable e)
		{   SysLogger.log(SysLogger.WARNING,this,"Exception during request processing");
			e.printStackTrace();
		}
	}
	
	private void redirect(IURRepresentation response, HttpResponse aResponse) throws Throwable
	{	IAspectRedirectRequest ra=(IAspectRedirectRequest)response.getAspect(IAspectRedirectRequest.class);
		if (response.hasAspect(IAspectMultipart.class))
		{	IAspectMultipart mp=(IAspectMultipart)response.getAspect(IAspectMultipart.class);
			IURRepresentation[] parts=mp.getParts();
			for(int i=0; i<parts.length;i++)
			{	if(parts[i].hasAspect(IAspectCookie.class))
				{	IAspectCookie cp=(IAspectCookie)parts[i].getAspect(IAspectCookie.class);
					aResponse.addSetCookie(cp.getCookie());
				}
			}
		}
		long expires = response.getMeta().getPessimisticExpiryTime();
		aResponse.setDateField(HttpFields.__Expires,expires);
		aResponse.sendRedirect(ra.getURI());
	}
	
	
	private String convertURI(HttpRequest aRequest)
	{	org.mortbay.util.URI aURI=aRequest.getURI();
		String host = aRequest.getHost();
		String path = aURI.getPath();
		StringBuffer sb = new StringBuffer(8+host.length()+path.length());
		sb.append("jetty://");
		sb.append(host);
		sb.append(path);
		return sb.toString();
	}
	
	private void handleFailure(IURRepresentation response, HttpResponse httpResponse, HttpRequest httpRequest) throws Exception
	{	
		NetKernelException e =((NetKernelExceptionAspect)response.getAspect(NetKernelExceptionAspect.class)).getException();
		boolean rawOutputNeeded;
		if (e.getId().equals(TransportManager.EX_SERVICE_UNAVAILABLE))
		{	rawOutputNeeded=true;
			httpResponse.setStatus(HttpResponse.__503_Service_Unavailable);
		}
		else if (mExceptionHandler!=null)
		{	httpResponse.setStatus(HttpResponse.__500_Internal_Server_Error);
			String id=httpRequest.getRemoteHost();
			IURRepresentation result = mTransport.handleRequest(mExceptionHandler,response,id,getName(),true);
			if (!result.hasAspect(NetKernelExceptionAspect.class))
			{	outputOk(result,httpResponse, httpRequest.getURI().toString());
				rawOutputNeeded=false;
			}
			else
			{	System.out.println(((NetKernelExceptionAspect)result.getAspect(NetKernelExceptionAspect.class)).getException().toString());
				rawOutputNeeded=true;
			}
		}
		else
		{	String id = e.getDeepestId();
			int code;
			if (id.equals("com.ten60.netkernel.scheduler.NoAccessorFoundException"))
			{	code = HttpResponse.__404_Not_Found;
			}
			else
			{	code = HttpResponse.__500_Internal_Server_Error;
			}
			httpResponse.setStatus(code);
			rawOutputNeeded=true;
		}
		if (rawOutputNeeded)
		{	NetKernelExceptionAspect nkep=(NetKernelExceptionAspect)response.getAspect(NetKernelExceptionAspect.class);
			httpResponse.setContentType("text/xml");
			httpResponse.setDateField("Expires",0);
			OutputStream os=httpResponse.getOutputStream();
			nkep.write(os);
			os.flush();
			httpResponse.commit();
		}
	}
	
	private void outputOk(IURRepresentation response, HttpResponse httpResponse, String requestURI ) throws IOException, NetKernelException
	{	IURRepresentation bs=null;
		if (response.hasAspect(IAspectMultipart.class))
		{	IAspectMultipart mp=(IAspectMultipart)response.getAspect(IAspectMultipart.class);
			IURRepresentation[] parts=mp.getParts();
			for(int i=0; i<parts.length;i++)
			{	if(parts[i].hasAspect(IAspectCookie.class))
				{	IAspectCookie cp=(IAspectCookie)parts[i].getAspect(IAspectCookie.class);
					httpResponse.addSetCookie(cp.getCookie());
				}
			}
		}
		
		if (response.hasAspect(IAspectReadableBinaryStream.class))
		{	IAspectReadableBinaryStream rbs = (IAspectReadableBinaryStream)response.getAspect(IAspectReadableBinaryStream.class);
			int length = rbs.getContentLength();
			if (length>=0)
			{	httpResponse.setIntField("Content-Length",length);
			}
		}
		String mimeType=response.getMeta().getMimeType();
		if (mimeType==null && requestURI!=null)
		{	mimeType = getHttpContext().getMimeByExtension(requestURI);
		}
		if (mimeType!=null)
		{	
			if (mimeType.equals("text/html"))
			{	mimeType+=";charset=UTF-8";
			}
			else
			{
			}
			httpResponse.setContentType(mimeType);
			
		}
		
		long expires = response.getMeta().getPessimisticExpiryTime();
		
		httpResponse.setDateField(HttpFields.__Expires,expires);
		OutputStream os = httpResponse.getOutputStream();
		IAspectBinaryStream pbs = (IAspectBinaryStream)response.getAspect(IAspectBinaryStream.class);
		pbs.write(os);
		os.flush();
		httpResponse.commit();
	}
	
	public void initialize(HttpContext aContext)
	{
		super.initialize(aContext);
	}
	
	public void start() throws Exception
	{	
		mTransport = (JettyTransport)getHttpContext().getAttribute(JettyTransport.TRANSPORT_ATTR);
		super.start();
	}
	
}
