/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: FilteredPathAccessHandler.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2003/08/22 10:38:51 $
 *****************************************************************************/
package org.ten60.transport.jetty;

import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

/**
 *
 * @author  pjr
 */
public class FilteredPathAccessHandler extends AbstractHttpHandler
{
	
	private ArrayList mExcluded;
	
	/** Creates a new instance of IPAccessHandler */
	public FilteredPathAccessHandler()
	{
		super();
		mExcluded=new ArrayList();
	}
	
	public void handle(String str, String str1, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException
	{
		String path=httpRequest.getURI().getPath();
		if(isExcluded(path))
		{
			httpResponse.sendError(HttpResponse.__404_Not_Found);
			httpRequest.setHandled(true);
		}
	}
	
	public void setExclude(String pattern)
	{
		mExcluded.add(new Excluded(pattern, true));
	}
	
	public void setInclude(String pattern)
	{
		mExcluded.add(new Excluded(pattern, false));
	}
	
	private boolean isExcluded(String path)
	{
		Iterator it=mExcluded.iterator();
		boolean test=true;
		while(it.hasNext())
		{
			Excluded exc=(Excluded)it.next();
			Matcher m=exc.getPattern().matcher(path);
			if(m.matches())
			{
				//System.err.println(path+" matches "+exc.getPattern());
				test=exc.isExcluded();
			}
		}
		return test;
	}
	
	protected class Excluded
	{
		
		private Pattern pattern;
		//private String pattern;
		private boolean access;
		
		public Excluded(String apattern, boolean aaccess)
		{
			access=aaccess;
			pattern=Pattern.compile(apattern);
		}
		
		public Pattern getPattern()
		{
			return pattern;
		}
		
		public boolean isExcluded()
		{
			return access;
		}
	}
}

