/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: FilteredIPAccessHandler.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2003/08/22 10:38:51 $
 *****************************************************************************/
package org.ten60.transport.jetty;

import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.http.*;
import java.io.*;
import java.util.*;

/**
 *
 * @author  pjr
 */
public class FilteredIPAccessHandler extends AbstractHttpHandler{

	private ArrayList ips;
	
	/** Creates a new instance of IPAccessHandler */
	public FilteredIPAccessHandler() {
		super();
		ips=new ArrayList();
	}
	
	public void handle(String str, String str1, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
		String addr=httpRequest.getRemoteAddr();
		if (checkIP(addr)) return;
		httpResponse.sendError(HttpResponse.__403_Forbidden,"Access denied from "+addr);
		httpRequest.setHandled(true);
	}
	
	public void setAllowIP(String ip){
		ips.add(new IP(ip, true));
	}
	
	public void setDenyIP(String ip){
		ips.add(new IP(ip, false));
	}
	
	public boolean checkIP(String ip){
		IP test=new IP(ip, true);
		int addr[]=test.getAddress();
		boolean access=test.isAllowed();
		Iterator it=ips.iterator();
		boolean allowed=false;
		while(it.hasNext()){
			IP iprule=(IP)it.next();
			int ipruleaddr[]=iprule.getAddress();
			int check=0;
			for(int i=0;i<4;i++){
				if(ipruleaddr[i]==256 || ipruleaddr[i]==addr[i]) check++;
			}
			if(check==4){
				if(iprule.isAllowed()) allowed=true;
				else allowed=false;
			}
		}
		return allowed;
	}

	protected class IP{
	
		private int[] address;
		private boolean access;

		public IP(String ip, boolean aaccess){
			access=aaccess;
			address=new int[4];
			String frags[]=ip.split(".");
			for(int i=0; i<frags.length;i++){
				int value=0;
				if(frags[i].equals("*")) value=256;
				else value=Integer.parseInt(frags[i]);
				address[i]=value;

			}
		}

		public int[] getAddress(){
			return address;
		}

		public boolean isAllowed(){
			return access;
		}
	}
}

