/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ParameterNVPAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2003/12/19 13:31:57 $
 *****************************************************************************/
package org.ten60.transport.http.parameter.representation;

import javax.servlet.http.Cookie;
import com.ten60.netkernel.urii.*;

import org.ten60.netkernel.layer1.representation.*;

import org.mortbay.http.HttpRequest;
import org.mortbay.util.MultiMap;

/**
 *
 * @author  pjr
 */
public class ParameterNVPAspect implements IAspectNVP, IURAspect
{
	private HttpRequest mRequest;
	private MultiMap mParameters;
	
	/** Creates a new instance of ParameterNVPProxy */
	private ParameterNVPAspect(HttpRequest aRequest)
	{	mRequest=aRequest;
		mParameters = (MultiMap)aRequest.getParameters().clone();
	}
	
	public java.util.Set getNames()
	{	return mParameters.keySet(); //mRequest.getParameterNames();
	}
	
	public String getValue(String name)
	{	//return mRequest.getParameter(name);
		return (String)mParameters.getValue(name, 0);
		
	}
	
	public java.util.List getValues(String name)
	{	//return mRequest.getParameterValues(name);
		return mParameters.getValues(name);
	}
	
	public static IURRepresentation create(IURMeta aMeta, HttpRequest aRequest)
	{	return new MonoRepresentationImpl(aMeta, new ParameterNVPAspect(aRequest));
	}
	
}
