/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: HttpHandler.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2007/09/20 16:22:27 $
 *****************************************************************************/
package org.ten60.transport.jetty;

import org.ten60.transport.http.aspect.*;

import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

import com.ten60.netkernel.transport.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.module.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;

import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.http.*;

import org.w3c.dom.*;
import javax.servlet.http.Cookie;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import java.net.*;

/**
 * Jetty HTTP Handler.  Adds httpRequest/httpResponse to IAspectHttpRequestResponse for passing up to the HTTP Bridge layer or the Application.
 * @author  pjr
 */
public class HttpHandler extends AbstractHttpHandler
{
	private JettyTransport mTransport;
	private IURMeta mRequestMeta = new AlwaysExpiredMeta("http/request", 0);
	public static final URIdentifier HTTP_LITERAL_URI=new URIdentifier("literal:HTTPRequestResponse");

	public void initialize(HttpContext aContext)
	{	super.initialize(aContext);
	}
	
	public void start() throws Exception
	{	mTransport = (JettyTransport)getHttpContext().getAttribute(JettyTransport.TRANSPORT_ATTR);
		super.start();
	}

	public void handle(String str, String str1, HttpRequest httpRequest, HttpResponse httpResponse)
		throws HttpException, IOException
	{	try
		{   StringBuffer requestURL = httpRequest.getRequestURL();
			String query = httpRequest.getQuery();
			String requestURI;
			if (query!=null)
			{	StringBuffer b = new StringBuffer(requestURL.length()+1+query.length());
				b.append(requestURL);
				b.append('?');
				b.append(query);
				requestURI = b.toString();
			}
			else
			{	requestURI = requestURL.toString();
			}
			httpResponse.setField(HttpFields.__Server, "1060 NetKernel v3.3 - Powered by Jetty");
			IURRepresentation reqrespRepresentation=HTTPRequestResponseAspect.create(mRequestMeta, httpRequest, httpResponse);
			
			TransportManager tm=mTransport.getTransportManager();
			URRequest request = new URRequest(new URIdentifier(requestURI),tm,null, mTransport.getContext(), URRequest.RQT_SOURCE, null, null, IURAspect.class);
			request.addArg(HTTP_LITERAL_URI, reqrespRepresentation);
			IURRepresentation response=tm.handleRequest(request,mTransport);
			if (response.hasAspect(NetKernelExceptionAspect.class))
			{	handleFailure(response,httpResponse,httpRequest);
			}
		}	catch (Throwable e)
		{   SysLogger.log(SysLogger.WARNING,this,"Exception during request processing");
			e.printStackTrace();
		}
		finally
		{	httpResponse.commit();
		}
	}
	
	private void handleFailure(IURRepresentation response, HttpResponse httpResponse, HttpRequest httpRequest) throws Exception
	{	
		NetKernelExceptionAspect nkep=(NetKernelExceptionAspect)response.getAspect(NetKernelExceptionAspect.class);
		String id = nkep.getXMLException().getDeepestId();

		if (id.equals(TransportManager.EX_SERVICE_UNAVAILABLE))
		{	httpResponse.setStatus(HttpResponse.__503_Service_Unavailable);
		}
		else
		{	httpResponse.setStatus(HttpResponse.__500_Internal_Server_Error);
		}
		httpResponse.setContentType("text/xml");
		httpResponse.setDateField("Expires",0);
		OutputStream os=httpResponse.getOutputStream();
		nkep.write(os);
		os.flush();
	}
	
}